/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <sys/types.h>
#include "CondVariable.h"
#include "CritSection.h"

namespace NS_DM_Client
{
    namespace NS_Communication
    {
        class MessageProcessingState
		{
		public:
			MessageProcessingState();
			~MessageProcessingState();

			void DecCommandsCount();
			void DecCommandsCount(unsigned int count);
			unsigned int GetCommandsCount();
			bool HasAllCommandsProcessed();
			void IncCommandsCount(unsigned int delta);
			void SetCommandsCount(unsigned int cmdCount);
			void Wait();

		protected:
			unsigned int m_cmdCount;
			unsigned int m_messageID;
			
		private:
			MessageProcessingState(const MessageProcessingState &);
//			MessageProcessingState& operator = (const MessageProcessingState&);

			NS_Common::CritSection m_csProcState;
			NS_Common::CondVariable  m_condNoCommands;
		};
    }
}

