/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "commontypes.h"
#include <boost/shared_ptr.hpp>
#include <base/util/StringBuffer.h>
#include <syncml/core/AbstractCommand.h>
#include <syncml/core/ItemizedCommand.h>
#include <syncml/core/Alert.h>
#include <syncml/core/Add.h>
#include <syncml/core/Atomic.h>
#include <syncml/core/Copy.h>
#include <syncml/core/Delete.h>
#include <syncml/core/Exec.h>
#include <syncml/core/Get.h>
#include <syncml/core/Replace.h>
#include <syncml/core/Results.h>
#include <syncml/core/Sequence.h>
#include <syncml/core/Status.h>
#include <vector>


namespace NS_DM_Client
{
	/// Shared pointer to message
	typedef boost::shared_ptr<class Funambol::ItemizedCommand> ItemizedCommandPtr;
	typedef boost::shared_ptr<class Funambol::AbstractCommand> AbstractCommandPtr;

	typedef boost::shared_ptr<class Funambol::Alert>	AlertPtr;
	typedef boost::shared_ptr<class Funambol::Add>		AddPtr;
	typedef boost::shared_ptr<class Funambol::Atomic>	AtomicPtr;
	typedef boost::shared_ptr<class Funambol::Copy>		CopyPtr;
	typedef boost::shared_ptr<class Funambol::Delete>	DeletePtr;
	typedef boost::shared_ptr<class Funambol::Exec>		ExecPtr;
	typedef boost::shared_ptr<class Funambol::Get>		GetPtr;
	typedef boost::shared_ptr<class Funambol::Replace>	ReplacePtr;
	typedef boost::shared_ptr<class Funambol::Results>	ResultsPtr;
	typedef boost::shared_ptr<class Funambol::Sequence>	SequencePtr;
	typedef boost::shared_ptr<class Funambol::Status>	StatusPtr;


	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SCommandAdapter> SCommandPtr;
		typedef std::vector<SCommandPtr> SCommandsArray;

		class SCommandAdapter
		{
		public:
			typedef unsigned int CommandID;
			typedef enum {
				New,
				Sent,
				Processed,
				NoConnection,
				WrongAuthentication // on err 212
			} Status;

			SCommandAdapter();
			SCommandAdapter(const char *msgid, AbstractCommandPtr origcmd);
			virtual ~SCommandAdapter();

			/// Get the SyncML string of the message
			///
			/// Returned StringBuffer instance should be deleted by the caller
			virtual Funambol::StringBuffer * ToString();

			/// Set command's status
			///
			/// Status is set after message has been processed by the server
			void SetStatus(Status s) { m_status = s; };

			/// Get commnd's status
			Status GetStatus() { return m_status; };

			/// Set command reference of the command
			void SetCmdID(const char *);
			const char * GetCmdID() { return m_cmdid; };

			void SetMessageID(const char *);
			const char * GetMessageID() { return m_msgid; };

			/// Create specific instance of AbstractCommand class
			void Prepare();

			/// Get shared pointer to instance of ItemizedCommand.
			///
			/// Shared pointer could contain NULL object, if Prepare was not called before
			ItemizedCommandPtr Internal() { return m_ptrItemizedCommand; }

			/// Set originated command, of this one
			void SetOriginatedCommand(AbstractCommandPtr ocmd) { m_ptrOriginatedCommand = ocmd; };
			AbstractCommandPtr GetOriginatedCommand() { return m_ptrOriginatedCommand; };


		protected:
			ItemizedCommandPtr m_ptrItemizedCommand;
			AbstractCommandPtr m_ptrOriginatedCommand;
			char *m_cmdid;
			char *m_msgid;

			virtual void createItemizedCommand() = 0;

		private:
			Status    m_status;
			uint      m_msgLength;
		};
	}
}

