/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "common/Errors.h"
#include "treemanager/MOTreeCommand.h"
#include "treemanager/MOTreeResponseCommand.h"
#include "serverexchange/wrappers/CommandsSinkHolder.h"
#include "serverexchange/wrappers/SCommandAdapter.h"

#include "daemon/INotificationCenter.h"

namespace NS_DM_Client
{
    class ICommandDispatcher;
	class IResultCollector;
	class IServerExchangeManager;
	class ProfileComponentsHolder;

	/// Class represents SyncML command performer. All SyncMLcommands are performed through corresponding subclasses.
	/// Result of SyncML command is processed in two ways:
	///   1. if m_needResponse is true and m_pResCollector == NULL, another command is created to post result into the SEM
	///   2. if m_needResponse is true and m_pResCollector != NULL , result is sent into the m_pResCollector
    class ActionCommand : public MOTreeCommand, public NS_SyncMLCommand::CommandsSinkHolder
    {
    public:
		friend class MOTreeSequenceCommand;
		friend class MOTreeAtomicCommand;

		ActionCommand(ProfileComponentsHolder* prholder, AbstractCommandPtr cmd,
					  const String& msgID, const char* serverID = 0);
        virtual ~ActionCommand();

		void SetCommandsSink(NS_SyncMLCommand::ICommandsSink &);
        void SetNeedSendResponse(bool need)             { m_needResponse  = need; };
		void SetResultsCollector(IResultCollector *prc) { m_pResCollector = prc;  };
		StatusCode GetResult()                          { return m_resCode;       };

    protected:
		virtual MOTreeResponseCommand * CreateResponse();
		virtual bool                    InvokeResult();

		// ProvisionUpdate
		bool notifyProvisionUpdate(CommandType commandType, EventType eventType, StatusCode result);
        virtual Funambol::ArrayList* getListOfItems();
        // end ProvisionUpdate

		AbstractCommandPtr              m_command;		// pointer to command, set to be executed
		String                          m_messageID;		// store ID of message from server, the command was sent in
		bool                            m_needResponse;	// defines whether result code should be send to the SEM
		IResultCollector              * m_pResCollector;	// [delegate] optional value, class that can process result code instead of SEM
		ProfileComponentsHolder       * m_pProfile;		// [delegate] profile holder pointer
		StatusCode                      m_resCode;		// result of the command execution
		const char                    * m_serverID;		// id of server issued the command
    };
}
