/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Errors.h"
#include "treemanager/IResultCollector.h"
#include "treemanager/MOTreeSequenceCommand.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/wrappers/SResponseCommand.h"

namespace NS_DM_Client
{
    class MOTreeAtomicCommand : public ActionCommand, IResultCollector
	{
	public:
		MOTreeAtomicCommand(ProfileComponentsHolder* prholder,
							  AtomicPtr &command,
							  const String& msgID,
                              const char* serverId = 0);
		virtual ~MOTreeAtomicCommand();

		virtual bool Execute();

		virtual void PutResult(Funambol::AbstractCommand * pCommand, StatusCode result);

	protected:
		AtomicPtr m_AtomicCommand;
		std::vector<NS_SyncMLCommand::SResponseCommandPtr> m_commandsResults;

		ActionCommand * createProcessingCommand(Funambol::AbstractCommand &cmd);
		StatusCode processCommands(Funambol::ArrayList &clist);

        virtual Funambol::ArrayList* getListOfItems();

	private:
		MOTreeAtomicCommand(const MOTreeAtomicCommand&);
		MOTreeAtomicCommand& operator =(const MOTreeAtomicCommand&);

		StatusCode performOperation();
		void postCommandsResults(Funambol::ArrayList&);
		NS_SyncMLCommand::SCommandPtr findResultForCommand(const char *cmdID);

		Funambol::ArrayList* m_commandItems;
	};
}
