/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/MOTreeGetCommand.h"
#include "Errors.h"

#include "daemon/ProfileComponentsHolder.h"
#include "common/Buffer.h"

#include "Event.h"

namespace NS_DM_Client
{
    class MOTreeGetCommandTest : public MOTreeGetCommand
    {
    public:
        enum
        {
            e_CommandExecuted = NS_Common::EventEx::e_UserSignal,
            e_CommandDestroyed
        };

    public:
        // class responcible for deleting ItemizedCommand* command
        MOTreeGetCommandTest(ProfileComponentsHolder* prholder, GetPtr& command,
            const String& msgID, NS_Common::EventEx* sigEvent, StatusCode& result_status, Buffer& result);
        virtual ~MOTreeGetCommandTest(void);
    protected:
        virtual bool InvokeResult();
        virtual bool Execute();

    private:
        MOTreeGetCommandTest(const MOTreeGetCommandTest&);
        MOTreeGetCommandTest& operator =(const MOTreeGetCommandTest&);

    protected:
        StatusCode& m_resultStatus;
        Buffer& m_result;
        NS_Common::EventEx* m_sigEvent;
        bool m_executed;
    };
}

