/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <vector>
#include <map>
#include "common/commontypes.h"
#include "daemon/INotification.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class ClientAdapterStub;
	struct ProvisionInfoResponse;
	struct ProvisionInfoRequest;

	class ProvisionSubscribersHolder
	{
	public:
		ProvisionSubscribersHolder(ClientAdapterStub& clientAdapterStub);
		void Clear();
		void AddSubscriber(int msgId, const ProvisionInfoRequest& provision);
		void NotifySubscribers(const ProvisionInfoResponse& provision);

	private:
		struct ProvisionInfo
		{
			int m_msgId;
			bool m_monitorChildren;
			CommandType m_command;
			EventType m_event;
		};

	private:
		NS_Logging::Logger& m_logger;
		typedef String URI;
		typedef std::vector<ProvisionInfo> Requests;
		typedef std::map<URI, Requests> RegisteredRequests;
		RegisteredRequests m_registeredRequests;

		ClientAdapterStub& m_clientAdapterStub;

	private:
		typedef std::map<String, StringArray> SortedURIs;
		void sortURIs(SortedURIs& sortedURIs, const StringArray& URIs);
		bool isParentNode(const String& parent, const String& child);
		bool isMonitorChildren(RegisteredRequests::iterator request);

		void notifySubscriber(const String& URI, CommandType command, EventType event, StatusCode statusCode);
	};

}