#include "Message.h"

namespace NS_DM_Client
{
    const char* S_msgTypeDescription[] = 
    {
        "Open",
        "Close",
        "Get",
        "Set",
        "ConfirmationRequired", 
        "ConfirmationResponse",
        "ClientProfilies",
        "ProfileActivationStatus",
        "ProfileActivationStatusByServerID",
        "StartDMSession",
        "StartBootstrap",
        "StartDRMD",
        "ChangePassword",
        "ChangePasswordByServerID",
        "NotifyDMSession",
        "UnsubscribeDMSession",
        "CheckFirmwareUpdate",
        "NotifyFirmwareUpdate",
        "UnsubscribeFirmwareUpdate",
        "NotifyProvisioningUpdate",
        "UnsubscribeProvisioningUpdate",
        "Status",
        "CollectDRMD",
        "DRMDReady",
        "NetworkEntry"
    };

    const char* S_msgSubTypeDescription[] =
    {
        "DevInfo",
        "DevDetail",
        "DMAcc",
        "WiMAX",
        "WiMAXSupp",
        "WiMAX_Diagnostics",
        "ClientProfilieName",
        "EMSK",
        "DeviceID",
        "Manufacturer",
        "Model",
        "None",
        "OK",
        "Failed",
        "StopWaiting",
        "FirmwareDownload",
        "FirmwareUpdate",
        "FirmwareDownloadAndUpdate",
        "FirmwareInfo"
    };

    Message::Message(size_t id, MsgType msgType, MsgSubType msgSubType, const String& data):
        m_id(id), m_type(msgType), m_subType(msgSubType)
    {
        StringToBytes(data, m_data);
    }
    //-------------------------------------------------------------------------------------------

    Message::Message(size_t id, MsgType msgType, MsgSubType msgSubType, const std::vector<byte>& data):
        m_id(id), m_type(msgType), m_subType(msgSubType), m_data(data)
    {
    }
    //-------------------------------------------------------------------------------------------

    size_t Message::GetHeaderSize()
    {
        //                                       subtype          dataSize
        return sizeof(size_t) + sizeof(size_t) + sizeof(size_t) + sizeof(size_t);
    }
    //-------------------------------------------------------------------------------------------

    size_t Message::GetDataSize()
    {
        return sizeof(size_t);
    }
    //-------------------------------------------------------------------------------------------

    void Message::SetData(void* buffer, size_t size)
    {
        if (size == 0)
        {
            m_data.clear();
        return;
        }
        m_data.resize(size);
        memset(&m_data[0], 0, size);
        memcpy(&m_data[0], buffer, size);
    }
    //-------------------------------------------------------------------------------------------

    void BytesToString(const std::vector<byte>& bytes, String& str)
    {
        if (bytes.size() == 0) return;
        int size = bytes.size() + 1; // null terminate
        char* tempResult = (char *)malloc(size);
        if(tempResult == NULL) return;

        memset(tempResult, 0, size);
        memcpy(tempResult, &bytes[0], bytes.size());
        str = tempResult;
        if(tempResult) free(tempResult);
    }
    //-------------------------------------------------------------------------------------------

    void StringToBytes(const String& str, std::vector<byte>& bytes)
    {
        size_t size = str.size(); 
        if (size == 0) return;
        bytes.resize(size);
        memset(&bytes[0], 0, size);
        memcpy(&bytes[0], str.c_str(), size);
    }
}
