/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "MessageDefs.h"

namespace NS_DM_Client
{
	extern const char* S_msgTypeDescription[];
	extern const char* S_msgSubTypeDescription[];

	typedef unsigned char byte;

	struct Message
	{
		Message(size_t id, MsgType msgType, MsgSubType msgSubType, const String& data = "");
		Message(size_t id, MsgType msgType, MsgSubType msgSubType, const std::vector<byte>& data);
		Message() {};

		void SetData(void* buffer, size_t size);
		static size_t GetHeaderSize();
		static size_t GetDataSize();

		size_t m_id;
		MsgType m_type;
		MsgSubType m_subType;
		std::vector<byte> m_data;
		//String m_data;
	};

	void BytesToString(const std::vector<byte>& bytes, String& str);
	void StringToBytes(const String& str, std::vector<byte>& bytes);
}
