/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <stddef.h>

#include "DaemonDM/UserInteractionDefs.h"
#include "IFIFOWrapper.h"

#include "DaemonDM/IPCExchangeDefs.h"

namespace NS_DM_Client
{

extern const char* const c_MessageListenerLog;
extern const char* const c_DaemonIPCEngineLog;

extern const char* c_StopRequest;
extern const size_t c_StopRequestSize;

extern const char* c_messageRequestFifoName;
extern const char* c_messageResponseFifoName;

extern const char* c_IPCRequestFifoName;
extern const char* c_IPCResponseFifoName;

#pragma pack(push, 1)

struct UIExchangeHead
{
    UIExchangeHead()
    {
    }

    UIExchangeHead(UIMessageType type, size_t payload_size)
    {
        m_type = type;
        m_payload_size = payload_size;
    }

    UIMessageType m_type;
    size_t m_payload_size;
};

struct UIResponseExchangeHead
{
    UIResponseExchangeHead()
    {
    }

    UIResponseExchangeHead(StatusCode perform_code, size_t payload_size)
    {
        m_perform_code = perform_code;
        m_payload_size = payload_size;
    }

    StatusCode m_perform_code;
    size_t m_payload_size;
};

#pragma pack(pop)

bool initializeFifos(IFIFOWrapper*& request, IFIFOWrapper*& response, bool stop_listening = false, bool serverSide = false);
bool initializeIPCFifos(IFIFOWrapper*& request, IFIFOWrapper*& response, bool stop_listening = false, bool serverSide = false);
bool releaseFifos(IFIFOWrapper* request, IFIFOWrapper* response);

bool formPayloadFromOptPars(const UIOptionalParameters& pars, String& payload, bool allowMultipleChoise = false);
bool formOptParsFromPayload(const String& payload, UIOptionalParameters& pars, bool* allowMultipleChoise = 0);

bool get_MINDT(const UIOptionalParameters& pars, long& min_dt);
bool get_MAXDT(const UIOptionalParameters& pars, long& max_dt);
bool get_DR(const UIOptionalParameters& pars, String& def_val);
bool get_MAXLEN(const UIOptionalParameters& pars, long& max_len);
bool get_IT(const UIOptionalParameters& pars, String& input_type);
bool get_ET(const UIOptionalParameters& pars, bool& echo_password);

bool formComplexRequestPayload(
    const String& message, const String& pars, const String& choises, const String& downloads, void*& payload, size_t& payload_size);
bool formComplexRequest(UIMessageType type, void* payload, size_t payload_size, void*& request, size_t& request_size);

bool extractComplexRequestPayload(const void* payload, size_t payload_size,
    String& message, String& pars, String* choises = 0, String* downloads = 0);

bool formChoiseSet(const UserAvailableChoiseSet& choise_set, String& choises);
bool extractChoiseSet(const String& choises, UserAvailableChoiseSet& choise_set);
bool getNumericUserChoise(const String& available_choises, const String& user_choises, UserChoiseSet& choise_set);
bool formStringFromNumericUserChoise(const UserChoiseSet& choise_set, String& str_choise);
bool formNumericUserChoiseFromString(const String& str_choise, UserChoiseSet& choise_set);

void deleteMemory(void* memory);

}
