/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <map>
#include "CritSection.h"
#include "commontypes.h"

namespace NS_Logging
{
	class Logger;

	class LoggerFactory
	{
	public:
		static LoggerFactory& GetInstance();

		Logger& GetLogger(const char* name);
		void Release();

	protected:
		LoggerFactory();
		virtual ~LoggerFactory();

	private:
		static void destroy();
		void readConfiguration();
		typedef String LoggerName;
		void expandLoggerInfo(const String& loggerInfo, LoggerName& loggerName, size_t& level);
		void setDefaultCategoryForAllLogers();

		typedef std::map<LoggerName, Logger*> Loggers;
		Loggers m_loggers;

	private:
		static LoggerFactory* ms_instance;
		static NS_DM_Client::NS_Common::CritSection ms_critSection;
		static int ms_defaultLevel;
		NS_DM_Client::NS_Common::IOutStream* m_ostream;
		NS_DM_Client::NS_Common::CritSection m_loggerCritSection;
	};
}

