/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "XMLConfigurationParser.h"
#include <base/util/XMLProcessor.h>

namespace NS_DM_Client
{

XMLConfigurationParser::XMLConfigurationParser()
    : m_isGroup(false)
{


}

//-------------------------------------------------------------------------------------------

XMLConfigurationParser::~XMLConfigurationParser()
{

}

//-------------------------------------------------------------------------------------------

void XMLConfigurationParser::Release()
{
    delete this;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::Init(const char* configuration, const char* group)
{
    m_isGroup = false;
    m_xml = configuration;
    bool res = false;

    if (group)
    {   // check group existence
        m_group = group;
        res = checkGroupExist();
    }
    else
    {
        res = true;
    }

    if (!res)
    {
        m_xml.clear();
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::GetProperty(const String& name, String& value)
{
    // check Init status
    if (m_xml.empty())
    {
        return false;
    }

    return getProperty(name, value);

    return false;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::checkGroupExist()
{
    bool res = false;
    unsigned int start = 0;
    unsigned int end = 0;
    const char* ptr = Funambol::XMLProcessor::getElementContent(m_xml.c_str(), m_group.c_str(), NULL, &start, &end);
    if (ptr)
    {
        Funambol::StringBuffer buffer;
        Funambol::XMLProcessor::copyContent(m_xml.c_str(), start, end, buffer);
        if (buffer.c_str() != 0)
        {
            start = end = 0;
            if (Funambol::XMLProcessor::getElementAttributes(m_xml.c_str(), m_group.c_str(), &start, &end))
            {
                // if attributes exist than mean that group exist
                m_xml = buffer.c_str();
                m_isGroup = true;
                res = true;
            }
        }
    }

    if (!res)
    {
        m_group.clear();
    }

    return res;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::getProperty(const String& name, String& value)
{
    unsigned int start = 0;
    unsigned int end = 0;
    const char* node = Funambol::XMLProcessor::getElementContent(m_xml.c_str(), name.c_str(), 0, &start, &end);
    if (node)
    {
        Funambol::StringBuffer buffer;
        Funambol::XMLProcessor::copyContent(m_xml.c_str(), start, end, buffer);
        if (buffer.c_str())
        {
            value = buffer.c_str();
            return true;
        }
    }
    return false;
}

//-------------------------------------------------------------------------------------------

}
