/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <string.h>

#include "posix/TimeLog.h"

using namespace NS_DM_Client::NS_Common;

TimeLog::TimeLog()
{
    memset(&m_startTime, 0, sizeof(struct timespec));
    memset(&m_endTime, 0, sizeof(struct timespec));
}

TimeLog::~TimeLog()
{
}

int TimeLog::Snap()
{
    m_startTime = m_endTime;
    return clock_gettime(CLOCK_REALTIME, &m_endTime);
}

long int TimeLog::NanoSeconds()
{
    return (m_endTime.tv_sec - m_startTime.tv_sec) * 1e9 + m_endTime.tv_nsec - m_startTime.tv_nsec;
}
