/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "executionqueue/ICommand.h"
#include "executionqueue/QueueCommandRouter.h"
#include "executionqueue/CommandQueuePool.h"
#include "executionqueue/CommandsQueue.h"
#include "treemanager/MOTreeCommand.h"
#include "serverexchange/commands/ServerExchangeCommand.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_ExecutionQueue;

QueueCommandRouter::QueueCommandRouter(CommandQueuePool&  QPool)
: m_QPool(QPool)
{
}

QueueCommandRouter::~QueueCommandRouter()
{
}


bool QueueCommandRouter::Dispatch(ICommand& cmd)
{
    // WARNING unknown/unsupported command type
    return false;
}


bool QueueCommandRouter::Dispatch(MOTreeCommand& cmd)
{
    return m_QPool.GetMOTreeCmdQueue().Add(cmd);
}

bool QueueCommandRouter::Dispatch(ServerExchangeCommand& cmd)
{
    return m_QPool.GetServerExchangeCmdQueue().Add(cmd);
}



