#include <boost/test/unit_test.hpp>
#include <executionqueue/ExecutionQueue.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "daemon/Profile.h"

#include <treemanager/MOTreeCommand.h>
#include <executionqueue/ICommandDispatcher.h>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_ExecutionQueue;


static NS_Logging::Logger& logger = NS_Logging::GetLogger("ExecutionQueue");

class SupportedMOTreeCommand : public MOTreeCommand
{
public:
    virtual bool Execute()
    {
        return true;
    }

};

class UnsupportedCommand : public ICommand
{
public:
    virtual bool Execute()
    {
        return true;
    }

    bool Visit(ICommandDispatcher& cmdDispatcher)
    {
        return cmdDispatcher.Dispatch(*this);
    }

};


BOOST_AUTO_TEST_CASE(AddSupportedCommand)
{
	LOG_DEBUG_(logger, "AddSupportedCommand test is running. ");

    IExecutionQueue& eq = *new ExecutionQueue;

    StringMap params;
    String loggerInstanceName = "ExecutionQueue";
    
	NS_Daemon::Profile profile;	


    ProfileComponentsHolder    compHolder(profile);

    // init
    BOOST_CHECK(eq.Init(params, loggerInstanceName, compHolder));
    BOOST_CHECK(eq.Start());

    // check
    ICommand* cmd = new SupportedMOTreeCommand;
    BOOST_CHECK(eq.Add(*cmd));

    // finalize
    BOOST_CHECK(eq.Stop());
    eq.Release();

    delete &eq;
}


BOOST_AUTO_TEST_CASE(AddUnSupportedCommand)
{
	LOG_DEBUG_(logger, "AddUnSupportedCommand test is running. ");

    IExecutionQueue& eq = *new ExecutionQueue;

    StringMap params;
    String loggerInstanceName = "ExecutionQueue";
    
	NS_Daemon::Profile profile;	

	ProfileComponentsHolder    compHolder(profile);

    // init
    BOOST_CHECK(eq.Init(params, loggerInstanceName, compHolder));
    BOOST_CHECK(eq.Start());

    // check
    ICommand* cmd = new UnsupportedCommand;
    bool cmdAdded = eq.Add(*cmd);
    BOOST_CHECK(!cmdAdded);
    if (!cmdAdded)
    {
        delete cmd;
    }

    // finalize
    BOOST_CHECK(eq.Stop());
    eq.Release();

    delete &eq;
}


