#include "boost/filesystem/operations.hpp"
#include <boost/test/unit_test.hpp>
#include "serverexchange/commands/PropertiesReader.h"
#include <fstream>
#include <iostream>

BOOST_AUTO_TEST_SUITE(SuiteSEM)


BOOST_AUTO_TEST_CASE(TestCase_PropertiesReader)
{
	String testFileName  = "test.txt";
	const char *name1  = "Property1";
	const char *name2  = "Property1";
	const char *name3  = "Property2";
	const char *value1 = "val1";
	const char *value2 = "val2";
	const char *value3 = "val3";
	
	std::ofstream f;
	f.open(testFileName.c_str());
	if (f.is_open())
	{
		f << name1 << "=" << value1 << std::endl;
		f << name2 << "=" << value2 << std::endl;
		f << name3 << "=" << value3 << std::endl;
		f.close();
	}
	
	PropertiesReader pr(testFileName);

	std::cout << pr.size() << std::endl;
	if (pr.size())
	{
		std::cout << pr.begin()->uri   << std::endl;
		std::cout << pr.begin()->value << std::endl;
		std::cout << (pr.begin()+1)->uri   << std::endl;
		std::cout << (pr.begin()+1)->value << std::endl;
		std::cout << (pr.begin()+2)->uri   << std::endl;
		std::cout << (pr.begin()+2)->value << std::endl << std::endl << std::endl;

		
		std::cout << ((pr.begin()+0)->uri   == name1)  << std::endl;
		std::cout << ((pr.begin()+0)->value == value1) << std::endl;

		std::cout << ((pr.begin()+1)->uri   == name2)  << std::endl;
		std::cout << ((pr.begin()+1)->value == value2) << std::endl;

		std::cout << ((pr.begin()+2)->uri   == name3)  << std::endl;
		std::cout << ((pr.begin()+2)->value == value3) << std::endl;
	}

	BOOST_CHECK(0 < pr.size());
	BOOST_CHECK(3 == pr.size());
	BOOST_CHECK(pr.begin()->uri   == name1);
	BOOST_CHECK(pr.begin()->value == value1);

	BOOST_CHECK((pr.begin()+1)->uri   == name2);
	BOOST_CHECK((pr.begin()+1)->value == value2);

	BOOST_CHECK((pr.begin()+2)->uri   == name3);
	BOOST_CHECK((pr.begin()+2)->value == value3);

//	boost::filesystem::remove_all(testFileName);
}


BOOST_AUTO_TEST_SUITE_END()
