/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <base/util/utils.h>
#include <Utils.h>
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ComplexData.h>
#include <syncml/core/SourceRef.h>
#include <syncml/core/TargetRef.h>
#include "serverexchange/wrappers/SStatusCommand.h"
#include "commontypes.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "SStatusCommand";

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_SyncMLCommand;


SStatusCommand::SStatusCommand() :
    m_data(0), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
}


SStatusCommand::SStatusCommand(int data) :
    m_data(data), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
}


SStatusCommand::SStatusCommand(int data, AbstractCommandPtr origcmd) :
    m_data(data), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
    if (origcmd.get() != NULL)
    {
        SetCmd(origcmd->getName());
        if (origcmd->getCmdID())
            SetCmdRef(origcmd->getCmdID()->getCmdID());
    }
    else
    {
        GDLWARN("origcmd is NULL");
    }
}


SStatusCommand::~SStatusCommand()
{
    SAFE_DELETE_ARR(m_cmdName);
    SAFE_DELETE_ARR(m_targetref);
    SAFE_DELETE_ARR(m_sourceref);
}


void SStatusCommand::createItemizedCommand()
{
    Funambol::Status * pStatus = new Funambol::Status();
    if(pStatus == NULL) GDLWARN("new Funambol::Status");

    m_ptrItemizedCommand.reset(pStatus);

    Funambol::Data data(m_data);
    pStatus->setData(&data);
    pStatus->setCmd(m_cmdName);
    pStatus->setCmdRef(GetCmdRef());
    pStatus->setMsgRef(GetMsgRef());

    if (m_sourceref)
    {
        Funambol::ArrayList sources;
        Funambol::SourceRef source(m_sourceref);
        sources.add(source);
        this_status()->setSourceRef(&sources);
    }

    if (m_targetref)
    {
        Funambol::ArrayList targets;
        Funambol::TargetRef target(m_targetref);
        targets.add(target);
        this_status()->setTargetRef(&targets);
    }
}


Funambol::Status * SStatusCommand::GetStatus()
{
    return this_status();
}


int  SStatusCommand::GetData()
{
    return m_data;
}


void SStatusCommand::SetData(int data)
{
    m_data = data;
    if (m_ptrItemizedCommand.get())
    {
        char bf[DIM_64];
        __sprintf(bf, "%d", m_data);
        Funambol::ComplexData data(bf);
        this_status()->setData(&data);
    }
}


void SStatusCommand::SetCmd(const char *cmdName)
{
    SAFE_DELETE_ARR(m_cmdName);
    m_cmdName = Funambol::stringdup(cmdName);
}


void SStatusCommand::SetTargetRef(const char *target)
{
    SAFE_DELETE_ARR(m_targetref);
    m_targetref = Funambol::stringdup(target);
}


void SStatusCommand::SetSourceRef(const char *source)
{
    SAFE_DELETE_ARR(m_sourceref);
    m_sourceref = Funambol::stringdup(source);
}


Funambol::StringBuffer * SStatusCommand::ToString()
{
    if (m_ptrItemizedCommand.get())
        return Funambol::Formatter::getStatus(this_status());
    else
        return SCommandAdapter::ToString();
}

