/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "treemanager/MOTreeManagerListenerCollection.h"
#include "treemanager/IMOTreeManagerListener.h"

#include "daemon/ProfileComponentsHolder.h"

#include "treemanager/ServerPollingListener.h"
#include "treemanager/FUMORefUpdateListener.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "MOTreeManagerListenerCollection";
static const char* const c_FUMODefURIParam = "FUMODefURI";
static const char* const c_DefaultFUMODefURI = "./FUMO";

namespace NS_DM_Client
{
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::Init(ProfileComponentsHolder& pch, const StringMap& settings)
{
    bool res = true;

    m_settings = settings;

    return res;
}
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::AddListener(IMOTreeManagerListener* listener)
{
    bool res = true;
    m_listeners.push_back(listener);
    return res;
}
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::Release()
{
    bool res = true;

    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        (m_listeners[i])->Release();
    }

    delete this;
    return res;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnAdd(const URI& uri)
{
    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        m_listeners[i]->ExecuteOnAdd(uri);
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnDelete(const URI& uri)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnReplace(const URI& uri)
{
    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        m_listeners[i]->ExecuteOnReplace(uri);
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnCopy(const URI& source, const URI& dest)
{
    return true;
}

//-------------------------------------------------------------------------------------------

MOTreeManagerListenerCollection* GetMOTreeManagerListenerCollection(ProfileComponentsHolder& pch,const StringMap& settings)
{
    MOTreeManagerListenerCollection* ret = new(std::nothrow) MOTreeManagerListenerCollection;
    if (ret)
    {
        if (ret->Init(pch, settings))
        {
            // create predefined listeners

            while (true)
            {
                // Server Polling listener
                TreeServerPollingListener* server_polling_listener = new(std::nothrow) TreeServerPollingListener(pch);
                if (server_polling_listener)
                {
                    if (server_polling_listener->Init(pch))
                    {
                        ret->AddListener(server_polling_listener);
                    }
                    else
                    {
                        ret->Release();
                        ret = 0;
                        break;
                    }
                }
                else
                {
                    GDLWARN("new TreeServerPollingListener");
                    ret->Release();
                    ret = 0;
                    break;
                }

                // TO-FUMO-REF listener
                FUMORefUpdateListener* fumo_ref_listener = new(std::nothrow) FUMORefUpdateListener(pch);
                if (fumo_ref_listener)
                {
                    if (fumo_ref_listener->Init(pch))
                    {
                        const char* defValue = (const_cast<StringMap&>(settings).get(c_FUMODefURIParam)).c_str();
                        fumo_ref_listener->SetDefaultValue(defValue ? defValue : c_DefaultFUMODefURI);
                        ret->AddListener(fumo_ref_listener);
                    }
                    else
                    {
                        ret->Release();
                        ret = 0;
                        break;
                    }
                }
                else
                {
                    GDLWARN("new TFUMORefUpdateListener");
                    ret->Release();
                    ret = 0;
                    break;
                }

                break;
            }
        }
    }
    else
    {
        GDLWARN("new MOTreeManagerListenerCollection");
    }

    return ret;
}

}
