/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "treemanager/MOTreeItemisedCommand.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "MOTreeSequenceCommand";

using namespace NS_DM_Client;


MOTreeItemisedCommand::MOTreeItemisedCommand(ProfileComponentsHolder* prholder, ItemizedCommandPtr cmd,
    const String& msgID, const char* serverID)
    : ActionCommand(prholder, cmd, msgID, serverID), m_itccommand(cmd)
{
    if(cmd.get() == NULL)
    {
        GDLWARN("cmd is NULL");
    }
}


MOTreeResponseCommand * MOTreeItemisedCommand::CreateResponse()
{
    MOTreeResponseCommand *pResponse =
        new(std::nothrow) MOTreeResponseCommand(*m_pProfile->GetServerExchangeManager(), m_itccommand, m_resCode, m_messageID, m_serverID);
    if(pResponse == (MOTreeResponseCommand*)NULL)
    {
        GDLWARN("new MOTreeResponseCommand");
    }

    if (m_pCommandsSink)
        pResponse->SetCommandsSink(*m_pCommandsSink);
    
    return pResponse;
}
