/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "commontypes.h"
#include <PortableThread.h>
#include "CritSection.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class IFIFOWrapper;
	struct Message;
	class ProfileComponentsHolder;
	class IMgmtObject;
	class NotificationStub;

	namespace NS_Daemon
	{
		class Configuration;
	}

    class Buffer;

	class ClientAdapterStub
	{
		friend class RequestReceiverThread;
		friend class RequestHandlingThread;
		friend class NotificationStub;

		friend void SetFIFOWrappers(ClientAdapterStub& clientAdapterStub, NS_DM_Client::IFIFOWrapper* inFIFOWrapper,
			NS_DM_Client::IFIFOWrapper* outFIFOWrapper); // for tests only

	public:
		ClientAdapterStub(NS_Daemon::Configuration& configuration);
		virtual ~ClientAdapterStub();

		bool Init();
		bool Start(); // start waiting for requests in another thread
		bool Stop(); // stop waiting for requests

	private:
		void receiveRequest();
		bool receiveRequest(Message& request);

		bool restartFifos();
		bool stopRequestReceiverThread();

		void handleRequest(const Message& request);
		bool handleRequest(const Message& request, Message& response);
		bool handleOpenType(Message& response);
		bool handleCloseType(Message& response);
		bool handleGetType(const Message& request, Message& response);
		bool handleClientProfilesType(const Message& request, Message& response);
		bool handleClientProfileNameType(const Message& request, Message& response);

		// EMSK
		bool handleSetEMSKType(const Message& request, Message& response);
		bool handleGetEMSKType(const Message& request, Message& response);

		// DeviceID
		bool handleSetDeviceIDType(const Message& request, Message& response);

		// requests with notifications
		bool handleStartDMSessionType(const Message& request, Message& response);
		bool handleDMSessionNotifType(const Message& request, Message& response);
		bool handleCheckFirmwareUpdateType(const Message& request, Message& response);
		bool handleFirmwareUpdateNotifType(const Message& request, Message& response);
		bool handleProvisioningUpdateNotifType(const Message& request, Message& response);
		bool handleSetType(const Message& request, Message& response);
		bool handleSetKnownMgmtObject(IMgmtObject& mgmtObject, const Message& request, Message& response);
		bool handleSetUnknownSubType(const Message& request, Message& response);
		bool handleGetKnownMgmtObject(IMgmtObject& mgmtObject, const Message& request, Message& response);
		bool handleGetUnknownSubType(const Message& request, Message& response);
		bool handleNetworkEntry(const Message& request, Message& response);
		bool handleDRMDReady(const Message& request, Message& response);
		bool handleCollectDRMD(const Message& request, Message& response);

		IMgmtObject* getMgmtObject(size_t subType);

//		void createGetCommand();

		bool sendResponse(const Message& response);
		bool sendResponseHelper(const Message& response);
		bool sendClientProfilesResponse(const Message& response);

	private:
		Thread* m_receiver;
		NS_Daemon::Configuration& m_configuration;
		ProfileComponentsHolder* m_componentHolder;
		IFIFOWrapper* m_inFIFOWrapper; // for incoming messages (inFIFOWrapper for Stub is outFIFOWrapper for Proxy)
		IFIFOWrapper* m_outFIFOWrapper; // for outgoing messages (outFIFOWrapper for Stub is inFIFOWrapper for Proxy)
		NS_Logging::Logger& m_logger;
		NS_Common::CritSection m_criticalSection;
		bool m_stopReceiving;
		NotificationStub* m_notification;
	};
}
