/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "platform.h"
#include "commontypes.h"
#include "DeviceAdapter/FirmwareUpdate/IFirmwareUpdater.h"

#ifdef PLATFORM_LINUX
	#define DEVICE_ADAPTER_API
#elif defined(PLATFORM_WINDOWS)
	#ifdef DEVICE_ADAPTER_EXPORTS
		#define DEVICE_ADAPTER_API __declspec(dllexport)
	#else
		#define DEVICE_ADAPTER_API __declspec(dllimport)
	#endif // DEVICE_ADAPTER_EXPORTS
#else
	#define DEVICE_ADAPTER_API
#endif


namespace NS_DM_Client
{
	class DevInfo;
	class DevDetail;
	class DMAcc;
	class WiMAX;
	class WiMAXSupp;
	class IDaemonEngineRequest;

	typedef unsigned char byte;

	class IDeviceAdapter
	{
	public:
		virtual ~IDeviceAdapter() {}

		/// Initialize adapter
		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0) = 0;
		/// Release adapter
		virtual void Release() = 0;

		/// Open the device
		virtual bool Open() = 0;
		/// Close the device
		virtual bool Close() = 0;

		//
		// MO tree API
		//
		virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
		virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
		virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
		virtual bool GetWiMAX(WiMAX& wimax) = 0;
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
		virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
		virtual bool SetWiMAX(const WiMAX& wimax) = 0;
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;

		//virtual bool Set
		//
		// Firmware update (FUMO) API
		//
		typedef IFirmwareUpdater::EnumFirmwareStatus	EnumFirmwareStatus;
		virtual EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0) = 0;
		virtual EnumFirmwareStatus ResetFirmwareStorage() = 0;
		virtual EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last) = 0;
		virtual EnumFirmwareStatus UpdateFirmware() = 0;

		/// Set/Get Extended Master Session Key
		virtual bool SetEMSK(const void*, size_t size) = 0;
		virtual bool GetEMSK(void*, size_t& size) = 0;

		/// Set/Get device network identifier (e.g. MAC address)
		virtual bool SetDeviceID(const void*, size_t size) = 0;
		virtual bool GetDeviceID(void*, size_t& size) = 0;

		/// Get network interface name assigned for the device in the system
		virtual bool GetNetworkInterfaceName(char*, size_t& size) = 0;

	};

	static const char EMSKSourceParam[] = "EMSKSource";

	static const char FirmwareDefaultLocationParam[] = "FirmwareDefaultLocation";
	static const char FirmwarePackageDefaultNameParam[] = "FirmwarePackageDefaultName";
	static const char FirmwareStorageNoCleanParam[] = "FirmwareStorageNoClean";
	static const char FirmwareUpdateResultParam[] = "FirmwareUpdateResult";

	static const char DeviceIDParam[] = "DeviceID";
	static const char NetworkIFParam[] = "NetworkIF";
}

extern "C" DEVICE_ADAPTER_API NS_DM_Client::IDeviceAdapter* CreateDeviceAdapter(void* param);
