/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#include <daemon/INotificationCenter.h>

#include <commontypes.h>
#include <CritSection.h>

#include <map>

namespace NS_DM_Client
{
	class NotificationCenter: public INotificationCenter
	{
	public:
		NotificationCenter();
		virtual ~NotificationCenter();
		virtual bool Subscribe(INotification* notif);
		virtual bool Unsubscribe(INotification* notif);

		virtual void StartDMSessionStatus(bool started);
		virtual void CheckFirmwareUpdateStatus(bool isNewFirmware);

		virtual void SessionStarted(bool isSuccessful);
		virtual void SessionAborted();
		virtual void SessionFinished();
		
		virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fi);
		virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fi);

		virtual void StartDRMDCollecting(int duration);

	protected:
		NotificationCenter(const INotificationCenter&);
		NotificationCenter& operator =(const INotificationCenter&);

		bool exists(INotification* notif);

	protected:
		typedef std::map<void*, INotification*>	Notifications;
		Notifications				m_notifs;
		NS_Common::CritSection		m_notifsGuard;
	};
}

