/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <executionqueue/ICommandsQueue.h>
#include <list>

#include <Event.h>
#include <CritSection.h>

#include <Logger/Logger.h>

namespace NS_DM_Client
{
    using NS_Common::EventEx;
    using NS_Common::CritSection;

    namespace NS_ExecutionQueue
    {
        class CommandInvokeThread;

        enum EnumResumeReason
        {
            e_NewCommand = NS_Common::EventEx::e_UserSignal,

            e_Stop = NS_Common::EventEx::e_Stop
        };

        class CommandsQueue :
            public ICommandsQueue
        {
        public:
            typedef std::list<ICommand*>    Commands;

            friend class CommandInvokeThread;

            CommandsQueue(NS_Logging::Logger& log);
            virtual ~CommandsQueue(void);

            virtual bool Init();
            virtual bool Add(ICommand& cmd);
            virtual bool StopCommandExecution();

        protected:
            ICommand*   getCommand();
            ICommand*   popCommand();

            void		discardWaitingCommands();

        private:
            Commands                m_Cmds;
            CritSection             m_CmdsLocker;
            EventEx                 m_resEvent;
            CommandInvokeThread*        m_CmdInvokeThread;

            NS_Logging::Logger&     m_logger;
        };

    }

}
