/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <http/TransportAgentFactory.h>
#include <syncml/core/Status.h>

#include "serverexchange/ConnectionInfo.h"
#include "serverexchange/commands/AlertCodes.h"
#include "serverexchange/CommandStorage.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/wrappers/SStatusCommand.h"


namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	
	namespace NS_Communication
	{
		/// Class ISession defines interface of the connection session abstraction.
		class ISession
		{
		public:
			/// ConnectionState stores settings and states of the connection
			typedef struct tagState {
				bool AddInitialAlert;
				bool ClientAuthenticated;
				bool ServerAuthenticated;
				NS_SyncMLCommand::AlertCode InitialAlertCode;
				
				tagState() {
					AddInitialAlert     = true;
					ClientAuthenticated = false;
					ServerAuthenticated = false;
					InitialAlertCode    = NS_SyncMLCommand::AC_CLIENT_INITIATED_MGMT;
				}
			} ConnectionState;

		public:
			virtual      ~ISession() {};

			/// Check whether session support authentication with nonce exchange
			virtual bool AcceptsNonces() = 0;
			
			/// Check whether credentials were already sent to the recipient
			virtual bool CredentialsSent() = 0;

			/// Start connection and send commands
			/// Connection will be started even if commands list is empty
			/// Specific implementation should insert Alert,Replace[DevInfo] to initiate connection
			virtual void Connect(NS_SyncMLCommand::CommandStorage & commands) = 0;
			
			/// Create a session-specific Status on SyncHdr
			virtual NS_SyncMLCommand::SStatusCommand * 
			             CreateSyncHdrStatus(int code, const char * responseURI) = 0;
			
			/// Return name of the session authentication type
			/// Returned value should not be deleted
			virtual const char * GetTypeName() = 0;
			
			/// Check whether caller passes authentication
			virtual bool IsAuthenticationPassed(Funambol::Status &) = 0;
			
			/// Check whether response is valid according to session requirements 
			virtual	bool IsResponseValid(const char *, uint resplength) = 0;
			
			/// Check whether passed Cred contains valid auth data of the server
			virtual bool IsServerCredValid(Funambol::Cred *) = 0;
			
			/// Check whether session is in state of sending large object
			virtual bool IsSendingLO() = 0;

			/// Read authentication info from the Chal
			virtual bool ReadChal(Funambol::Chal &) = 0;

			/// Send message to server
			virtual void SendMessage(const char *) = 0;
			virtual void SendMessage(FStringBuffer &) = 0;
			
			/// Configure session with AccessConfig instance
			//virtual void SetAccessConfig  (Funambol::AccessConfig &) = 0;

			virtual void SetCommandsSink(NS_SyncMLCommand::ICommandsSink &) = 0;
			
			virtual void SetPCH(ProfileComponentsHolder &) = 0;
			
			// configure session
			const ConnectionState State()       { return m_state; };
			void SetAddInitialAlert(bool b)     { m_state.AddInitialAlert     = b; };
			void SetClientAuthenticated(bool b) { m_state.ClientAuthenticated = b; };
			void SetServerAuthenticated(bool b) { m_state.ServerAuthenticated = b; };
			void SetStartAlertCode(const NS_SyncMLCommand::AlertCode alertCode) { m_state.InitialAlertCode = alertCode; }
			
		protected:
			ConnectionState m_state;
		};
	}
}

