/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "Errors.h"
#include "treemanager/MOTreeCommand.h"
#include "serverexchange/commands/ServerExchangeCommand.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/ICommandsSink.h"
	
namespace NS_DM_Client
{
	//class ICommandsSink;
	class IServerExchangeManager;
    class ProfileComponentsHolder;

    class MOTreeResponseCommand : public ServerExchangeCommand
    {
    public:
        MOTreeResponseCommand(ProfileComponentsHolder* prholder, 
							  AbstractCommandPtr cmd, 
							  StatusCode cmdStatus, 
							  const String& msgID,
							  const char *serverid);
        virtual ~MOTreeResponseCommand();
		virtual bool Execute();
		void SetCommandsSink(NS_SyncMLCommand::ICommandsSink &);

	protected:
        AbstractCommandPtr	      m_command;
        ProfileComponentsHolder * m_pProfile;
        StatusCode			      m_status;
        const String		      m_messageID;
		const char              * m_serverID;
		NS_SyncMLCommand::ICommandsSink           * m_pCommandsSink;
		
        void enqueueCommand(NS_SyncMLCommand::SCommandPtr ptrCommand);

    private:
        MOTreeResponseCommand(const MOTreeResponseCommand&);
        MOTreeResponseCommand& operator =(const MOTreeResponseCommand&);

        bool performOperation();
    };
}
