/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#pragma once

#include "IFIFOWrapper.h"
#include <queue>

namespace NS_DM_Client
{
	typedef unsigned char byte;
	class ClientAdapterProxy;
	class ClientAdapterStub;

	void SetFIFOWrappers(ClientAdapterProxy& clientAdapterProxy, NS_DM_Client::IFIFOWrapper* inFIFOWrapper, 
		NS_DM_Client::IFIFOWrapper* outFIFOWrapper);
	void SetFIFOWrappers(ClientAdapterStub& clientAdapterStub, NS_DM_Client::IFIFOWrapper* inFIFOWrapper, 
		NS_DM_Client::IFIFOWrapper* outFIFOWrapper);

	// simulate FIFO's interprocess work but in the same process
	class MockFIFOWrapper: public IFIFOWrapper
	{
		friend void ClearFIFO(MockFIFOWrapper& fifoWrapper);

	public:
		MockFIFOWrapper();
		virtual ~MockFIFOWrapper();

		virtual StatusCode Open(const String& name, bool readMode, bool blockedMode, bool immediateOpen = false);
		virtual StatusCode Read(Buffer& buffer, bool exitIfNoWriter = false);
		virtual StatusCode Write(const Buffer& buffer, bool exitIfNoReader = false);
		virtual StatusCode Write(const void* buffer, size_t length, bool exitIfNoReader = false);
		virtual StatusCode Close();
		virtual void Release();

		size_t GetMessagesCount() const;
		void FreezeOff();

	private:
		void freeze();

	protected:
		virtual StatusCode open();

	private:
		typedef std::vector<byte> QueueData;
		std::queue<QueueData> m_queue;
		bool m_isFreezed;
	};

	void ClearFIFO(MockFIFOWrapper& fifoWrapper);
}
