/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include "CommonUtils.h"
#include "IFIFOWrapper.h"
#include "Message.h"
#include "Logger.h"
#include "lock.h"
#include "ManagementObjects/DevInfo.h"
#include "ManagementObjects/DevDetail.h"
#include "ManagementObjects/DMAcc.h"
#include "ManagementObjects/WiMAX.h"
#include "ManagementObjects/WiMAXSupp.h"

namespace NS_DM_Client
{
	const String S_inFifoName("ClientAdapterInMessages");
	const String S_outFifoName("ClientAdapterOutMessages");
	const String S_profileInfoSeperator(" ");

	const String S_true("true");
	const String S_false("false");
	const char* S_notificationStatusDescription[] =
	{
		"unknown",
		"started",
		"finished",
		"aborted"
	};

	//-------------------------------------------------------------------------------------------

	bool CreateFIFOWrapperEx(IFIFOWrapper*& fifoWrapper, const String& fifoName, bool isForReading, bool isServerSide, bool isBlocked)
	{
		fifoWrapper = CreateFIFOWrapper(isServerSide);
		if (fifoWrapper)
		{
			bool res = (fifoWrapper->Open(fifoName, isForReading, isBlocked) == e_Ok);
			return res;
		}
		return false;
	}
	//-------------------------------------------------------------------------------------------

	bool ReadMessageFromFIFO(IFIFOWrapper* fifoWrapper, Buffer& buffer,
		NS_Logging::Logger& logger, NS_Common::CritSection& criticalSection/* = 0*/)
	{
		NS_Common::Lock lock(criticalSection);
		// read header
		size_t headerSize = Message::GetHeaderSize();
		Buffer headerBuffer(headerSize);
		bool res = (fifoWrapper->Read(headerBuffer) == e_Ok);
		if (!res)
		{
			LOG_ERROR_(logger, "Failed to read header from fifo \"%s\"", S_inFifoName.c_str());
			return res;
		}
		LOG_(logger, "Read header from fifo");
		res = buffer.Allocate(headerSize);
		memcpy(buffer.GetPointer(), headerBuffer.GetPointer(), headerSize);

		// retrieve body size
		size_t dataSize = Message::GetDataSize();
		size_t bodySize = 0;

		char* body = reinterpret_cast<char*>(headerBuffer.GetPointer());
		body += headerSize - dataSize;
		memcpy(&bodySize, body, dataSize);

		LOG_(logger, "Trying to read body, body size = %d", bodySize);
		if (bodySize != 0)
		{
			Buffer bodyBuffer(bodySize);
			res = (fifoWrapper->Read(bodyBuffer) == e_Ok);
			if (!res)
			{
				LOG_ERROR_(logger, "Failed to read body from fifo \"%s\"", S_inFifoName.c_str());
				return res;
			}

			buffer.Allocate(buffer.Size() + bodySize);
			memcpy(reinterpret_cast<char*>(buffer.GetPointer()) + headerSize, bodyBuffer.GetPointer(), bodySize);
		}
		return res;
	}
	//-------------------------------------------------------------------------------------------

	IMgmtObject* GetMgmtObject(size_t subType)
	{
		IMgmtObject* mgmtObject = 0;
		switch (subType)
		{
		case e_devInfo:
			mgmtObject = new DevInfo();
			break;
		case e_devDetail:
			mgmtObject = new DevDetail();
			break;
		case e_DMAcc:
			mgmtObject = new DMAcc();
			break;
		case e_WiMAX:
			mgmtObject = new WiMAX();
			break;
		case e_WiMAXSupp:
			mgmtObject = new WiMAXSupp();
			break;
		default:
			break;
		}
		return mgmtObject;
	}
	//-------------------------------------------------------------------------------------------

}
