/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "DaemonDM/MessageListener.h"
#include "DaemonDM/IMessageHandler.h"
#include "MessengerDefs.h"
#include "IFIFOWrapper.h"

#include "Logger/Logger.h"

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::Init(IMessageHandler* message_handler)
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::Init");
    m_message_handler = message_handler;
    m_actionThread.Init(this);
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::Init, Return status: %d", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
bool MessageListener::Release()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::Release");
    return false;
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::Release, Return status: %d", true);
}
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::WaitMessages()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::WaitMessages");
    if (m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_MessageListenerLog), "%s", "lisener already wait for messages");
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::WaitMessages, Return status: %d", e_Ok);
        return e_Ok;
    }
    m_actionThread.start();
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::WaitMessages, Return status: %d", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::StopWaitingMessages()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::StopWaitingMessages");
    if (!m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_MessageListenerLog), "%s", "lisener don't wait for messages. no need stop");
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d", e_Ok);
        return e_Ok;
    }
    IFIFOWrapper *fifo_stop_request, *fifo_stop_responce;
    if (!initializeFifos(fifo_stop_request, fifo_stop_responce, true))
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d, reason: initialize fifos failed", e_Failed);
        return e_Failed;
    }
    Buffer stop_request(sizeof(UIExchangeHead));
    memcpy(stop_request.GetPointer(), c_StopRequest, strlen(c_StopRequest)); // "stop\0" alvays smaller then sizeof(UIExchangeHead)
    if (fifo_stop_request->Write(stop_request) == e_Ok)
    {
        m_actionThread.wait();
    }
    else
    {
        releaseFifos(fifo_stop_request, fifo_stop_responce);
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d, reason: write to stop fifo failed", e_Failed);
        return e_Failed;
    }
    releaseFifos(fifo_stop_request, fifo_stop_responce);
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status %d:", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
IMessageHandler* MessageListener::GetMessageHandler()
{
    return m_message_handler;
}
//------------------------------------------------------------------------------------------------------
MessageListener::~MessageListener()
{
}
//------------------------------------------------------------------------------------------------------


}
