/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#pragma once

#include "DaemonDM/IMessageHandler.h"


namespace NS_DM_Client
{
const size_t cMaxDefSize = 256;

class CUIMessageHandler : public IMessageHandler
{
public:
    CUIMessageHandler(
        const char* default_user_input,
        const char* default_user_confirm,
        const char* default_user_choise,
        bool* downloadCancel);

    virtual bool Init();
    virtual bool Release();

    virtual StatusCode Display(const char* message, long min_time, long max_time);
    virtual StatusCode Confirmation(const char* message, long min_time, long max_time);
    virtual StatusCode UserInput(const char* message, long min_time, long max_time, char*& input,
        long* max_len = 0, bool echo_password = 0);
    virtual StatusCode UserChoice(const char* message, long min_time, long max_time,
        const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises);
    virtual StatusCode ProgressNotification(const char* message, long min_time, long max_time,
        long size_to_download);

    virtual void ReleaseString(char* str);

    virtual ~CUIMessageHandler();

private:
    char m_defUserInput[cMaxDefSize];
    char m_defUserConfirm[2];
    char m_defUserChoise[cMaxDefSize];
    bool m_downloadCancel;
};


}
