/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */
#include "DataStorageDefs.h"

#include <string>
#include <stdio.h>
#include <errno.h>

namespace NS_DM_Client
{

namespace NS_DataStorage
{

const DWORD c_maxEnvironmentStringSize = 1024;
	
//------------------------------------------------------------------------------------------------------
void str_replace(String& src, const String& what, const String& with)
{
    if (what != with) {
        String temp;
        String::size_type prev_pos = 0, pos = src.find(what, 0);
        while (String::npos != pos)
        {
            temp += String(src.begin() + prev_pos, src.begin() + pos) + with;
            prev_pos = pos + what.size();
            pos = src.find(what, prev_pos);
        }
        if (!temp.empty())
        {
            src = temp + String(src.begin() + prev_pos, src.end());
            if (String::npos == with.find(what))
            {
                str_replace(src, what, with);
            }
        }
    }
}
//------------------------------------------------------------------------------------------------------
bool ExpandStringWithEnvironmentVars(const String& in, String& out)
{
	bool res = false;
	
	char* buffer = (char*)malloc(c_maxEnvironmentStringSize);
	if (buffer)
	{
		// MSDN: When using ANSI strings, the buffer size should be the string length, plus terminating null character, plus one
		if (ExpandEnvironmentStringsA(in.c_str(), buffer, c_maxEnvironmentStringSize - 2) != 0)
		{
			out = buffer;
			res = true;	
		}
		free(buffer);
	}

	return res;
}

//------------------------------------------------------------------------------------------------------

}
}
