/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "DevInfo.h"
#include "treemanager/IMOTreeManager.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"

namespace NS_DM_Client
{
    const String DevInfoFieldPath[] =
	{
		"./DevInfo/",
		"./DevInfo/",
		"./DevInfo/",
		"./DevInfo/",
		"./DevInfo/"
	};

	const String DevInfoFieldName[] =
	{
		"DevId",
		"Man",
		"Mod",
		"DmV",
		"Lang"
	};

	MANAGEMENTOBJECTS_API int i;

	bool DevInfo::Serialize(IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(DevInfoFieldPath[e_DevId] + DevInfoFieldName[e_DevId], m_DevId, treeManager);
		res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Man] + DevInfoFieldName[e_Man], m_Man, treeManager);
		res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Mod] + DevInfoFieldName[e_Mod], m_Mod, treeManager);
		res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_DmV] + DevInfoFieldName[e_DmV], m_DmV, treeManager);
		res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Lang] + DevInfoFieldName[e_Lang], m_Lang, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevInfo::Deserialize(IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(DevInfoFieldPath[e_DevId] + DevInfoFieldName[e_DevId], m_DevId, treeManager);
		res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Man] + DevInfoFieldName[e_Man], m_Man, treeManager);
		res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Mod] + DevInfoFieldName[e_Mod], m_Mod, treeManager);
		res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_DmV] + DevInfoFieldName[e_DmV], m_DmV, treeManager);
		res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Lang] + DevInfoFieldName[e_Lang], m_Lang, treeManager);

		return true; // for tests only
		//return res;
	}

	//-------------------------------------------------------------------------------------------

	bool DevInfo::Serialize(String& xml) const
	{
		TNDSCreator tree;
		tree.Append(DevInfoFieldPath[e_DevId], DevInfoFieldName[e_DevId], m_DevId);
		tree.Append(DevInfoFieldPath[e_Man], DevInfoFieldName[e_Man], m_Man);
		tree.Append(DevInfoFieldPath[e_Mod], DevInfoFieldName[e_Mod], m_Mod);
		tree.Append(DevInfoFieldPath[e_DmV], DevInfoFieldName[e_DmV], m_DmV);
		tree.Append(DevInfoFieldPath[e_Lang], DevInfoFieldName[e_Lang], m_Lang);

		tree.Get(xml);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool DevInfo::Deserialize(const String& xml)
	{
		TNDSExtractor extractor(xml);
		extractor.GetValue(DevInfoFieldName[e_DevId], m_DevId);
		extractor.GetValue(DevInfoFieldName[e_Man], m_Man);
		extractor.GetValue(DevInfoFieldName[e_Mod], m_Mod);
		extractor.GetValue(DevInfoFieldName[e_DmV], m_DmV);
		extractor.GetValue(DevInfoFieldName[e_Lang], m_Lang);

		return true;
	}


}
