/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "WiMAX.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"
#include "treemanager/IMOTreeManager.h"

namespace NS_DM_Client
{
	enum WiMAXEnum
	{
		e_WiMAXRadioModule = 0,
		e_TerminalEquipment,
		e_TO_WIMAX_REF,
		e_DevCap
	};

	const String WiMAXFieldPath[] = 
	{
		"./WiMAX",
		"./WiMAX",
		"./WiMAX",
		"./WiMAX"
	};

	const String WiMAXFieldName[] =
	{
		"WiMAXRadioModule",
		"TerminalEquipment",
		"TO-WiMAX-REF",
		"DevCap"
	};
	//-------------------------------------------------------------------------------------------

	enum WiMAXRadioModuleEnum
	{
		e_Man = 0,
		e_Mod,
		e_FwV,
		e_HwV,
		e_SwV,
		e_MACAddress,
		e_SPLock,
		e_TO_FUMO_REF
	};

	const char* WiMAXRadioModuleFieldName[] =
	{
		"Man",
		"Mod",
		"FwV",
		"HwV",
		"SwV",
		"MACAddress",
		"SPLock",
		"TO-FUMO-REF"
	};
	//-------------------------------------------------------------------------------------------

	enum SPLockEnum
	{
		e_LockStatus = 0,
		e_Operator,
		e_VerNbr,
		e_Lock
	};

	const char* SPLockFieldName[] =
	{
		"LockStatus",
		"Operator",
		"VerNbr",
		"Lock"
	};
	//-------------------------------------------------------------------------------------------

	enum TerminalEquipmentEnum
	{
		e_TEDevID = 0,
		e_TEDevTyp,
		e_TEMan,
		e_TEMod,
		e_TEFwV,
		e_TEHwV,
		e_TESwV
	};

	const char* TerminalEquipmentFieldName[] =
	{
		"DevID",
		"DevTyp",
		"Man",
		"Mod",
		"FwV",
		"HwV",
		"SwV"
	};
	//-------------------------------------------------------------------------------------------

	enum DevCapEnum
	{
		e_IPCap = 0,
		e_UpdateMethods
	};

	const char* DevCapFieldName[] =
	{
		"IPCap",
		"UpdateMethods"
	};
	//-------------------------------------------------------------------------------------------

	enum IPCapEnum
	{
		e_IPV4 = 0,
		e_IPV6,
		e_CMIPV4,
		e_CMIPV6
	};

	const char* IPCapFieldName[] =
	{
		"IPV4",
		"IPV6",
		"CMIPV4",
		"CMIPV6"
	};
	//-------------------------------------------------------------------------------------------

	enum UpdateMethodsEnum
	{
		e_ServerInitiated = 0,
		e_ClientInitiated
	};

	const char* UpdateMethodsFieldName[] =
	{
		"ServerInitiated",
		"ClientInitiated"
	};
	//-------------------------------------------------------------------------------------------

	enum ClientInitiatedEnum
	{
		e_PollingSupported = 0,
		e_PollingInterval
	};

	const char* ClientInitiatedFieldName[] =
	{
		"PollingSupported",
		"PollingInterval"
	};
	//-------------------------------------------------------------------------------------------

	bool ClientInitiated::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + ClientInitiatedFieldName[e_PollingSupported], BoolToString(m_PollingSupported), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + ClientInitiatedFieldName[e_PollingInterval], ToString(m_PollingInterval), treeManager, S_intFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ClientInitiated::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + ClientInitiatedFieldName[e_PollingSupported], m_PollingSupported, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + ClientInitiatedFieldName[e_PollingInterval], m_PollingInterval, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool ClientInitiated::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, ClientInitiatedFieldName[e_PollingSupported], ToString(m_PollingSupported));
		tree.Append(basePathName, ClientInitiatedFieldName[e_PollingInterval], ToString(m_PollingInterval));
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool ClientInitiated::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, ClientInitiatedFieldName[e_PollingSupported], m_PollingSupported);
		tree.GetValue(basePathName, ClientInitiatedFieldName[e_PollingInterval], m_PollingInterval);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool UpdateMethods::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + UpdateMethodsFieldName[e_ServerInitiated], ToString(m_ServerInitiated), treeManager, S_boolFormat);
		res &= m_ClientInitiated.Serialize(basePathName + S_slash + UpdateMethodsFieldName[e_ClientInitiated], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool UpdateMethods::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + UpdateMethodsFieldName[e_ServerInitiated], m_ServerInitiated, treeManager);
		res &= m_ClientInitiated.Deserialize(basePathName + S_slash + UpdateMethodsFieldName[e_ClientInitiated], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool UpdateMethods::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, UpdateMethodsFieldName[e_ServerInitiated], ToString(m_ServerInitiated));
		bool res = m_ClientInitiated.Serialize(basePathName + S_slash + UpdateMethodsFieldName[e_ClientInitiated], tree);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool UpdateMethods::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, UpdateMethodsFieldName[e_ServerInitiated], m_ServerInitiated);
		bool res = m_ClientInitiated.Deserialize(basePathName + S_slash + UpdateMethodsFieldName[e_ClientInitiated], tree);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool IPCap::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + IPCapFieldName[e_IPV4], ToString(m_IPV4), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + IPCapFieldName[e_IPV6], ToString(m_IPV6), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + IPCapFieldName[e_CMIPV4], ToString(m_CMIPV4), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + IPCapFieldName[e_CMIPV6], ToString(m_CMIPV6), treeManager, S_boolFormat);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool IPCap::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + IPCapFieldName[e_IPV4], m_IPV4, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + IPCapFieldName[e_IPV6], m_IPV6, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + IPCapFieldName[e_CMIPV4], m_CMIPV4, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + IPCapFieldName[e_CMIPV6], m_CMIPV6, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool IPCap::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, IPCapFieldName[e_IPV4], ToString(m_IPV4));
		tree.Append(basePathName, IPCapFieldName[e_IPV6], ToString(m_IPV6));
		tree.Append(basePathName, IPCapFieldName[e_CMIPV4], ToString(m_CMIPV4));
		tree.Append(basePathName, IPCapFieldName[e_CMIPV6], ToString(m_CMIPV6));
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool IPCap::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, IPCapFieldName[e_IPV4], m_IPV4);
		tree.GetValue(basePathName, IPCapFieldName[e_IPV6], m_IPV6);
		tree.GetValue(basePathName, IPCapFieldName[e_CMIPV4], m_CMIPV4);
		tree.GetValue(basePathName, IPCapFieldName[e_CMIPV6], m_CMIPV6);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool DevCap::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = m_IPCap.Serialize(basePathName + S_slash + DevCapFieldName[e_IPCap], treeManager);
		res &= m_UpdateMethods.Serialize(basePathName + S_slash + DevCapFieldName[e_UpdateMethods], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevCap::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = m_IPCap.Deserialize(basePathName + S_slash + DevCapFieldName[e_IPCap], treeManager);
		res &= m_UpdateMethods.Deserialize(basePathName + S_slash + DevCapFieldName[e_UpdateMethods], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevCap::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		bool res = m_IPCap.Serialize(basePathName + S_slash + DevCapFieldName[e_IPCap], tree);
		res &= m_UpdateMethods.Serialize(basePathName + S_slash + DevCapFieldName[e_UpdateMethods], tree);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool DevCap::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		bool res = m_IPCap.Deserialize(basePathName + S_slash + DevCapFieldName[e_IPCap], tree);
		res &= m_UpdateMethods.Deserialize(basePathName + S_slash + DevCapFieldName[e_UpdateMethods], tree);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool TerminalEquipment::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEDevID], m_DevID, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEDevTyp], m_DevTyp, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEMan], m_Man, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEMod], m_Mod, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEFwV], m_FwV, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEHwV], m_HwV, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TESwV], m_SwV, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool TerminalEquipment::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEDevID], m_DevID, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEDevTyp], m_DevTyp, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEMan], m_Man, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEMod], m_Mod, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEFwV], m_FwV, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TEHwV], m_HwV, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + TerminalEquipmentFieldName[e_TESwV], m_SwV, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool TerminalEquipment::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEDevID], m_DevID);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEDevTyp], m_DevTyp);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEMan], m_Man);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEMod], m_Mod);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEFwV], m_FwV);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TEHwV], m_HwV);
		tree.Append(basePathName, TerminalEquipmentFieldName[e_TESwV], m_SwV);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool TerminalEquipment::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEDevID], m_DevID);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEDevTyp], m_DevTyp);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEMan], m_Man);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEMod], m_Mod);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEFwV], m_FwV);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TEHwV], m_HwV);
		tree.GetValue(basePathName, TerminalEquipmentFieldName[e_TESwV], m_SwV);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool SPLock::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + SPLockFieldName[e_LockStatus], ToString(m_LockStatus), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + SPLockFieldName[e_Operator], m_Operator, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + SPLockFieldName[e_VerNbr], ToString(m_VerNbr), treeManager, S_boolFormat);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + SPLockFieldName[e_Lock], m_Lock, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SPLock::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + SPLockFieldName[e_LockStatus], m_LockStatus, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + SPLockFieldName[e_Operator], m_Operator, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + SPLockFieldName[e_VerNbr], m_VerNbr, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + SPLockFieldName[e_Lock], m_Lock, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool SPLock::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, SPLockFieldName[e_LockStatus], ToString(m_LockStatus));
		tree.Append(basePathName, SPLockFieldName[e_Operator], m_Operator);
		tree.Append(basePathName, SPLockFieldName[e_VerNbr], ToString(m_VerNbr));
		tree.Append(basePathName, SPLockFieldName[e_Lock], m_Lock);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool SPLock::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, SPLockFieldName[e_LockStatus], m_LockStatus);
		tree.GetValue(basePathName, SPLockFieldName[e_Operator], m_Operator);
		tree.GetValue(basePathName, SPLockFieldName[e_VerNbr], m_VerNbr);
		tree.GetValue(basePathName, SPLockFieldName[e_Lock], m_Lock);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXRadioModule::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_Man], m_Man, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_Mod], m_Mod, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_FwV], m_FwV, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_HwV], m_HwV, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_SwV], m_SwV, treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_MACAddress], m_MACAddress, treeManager);
		// this line is commented because of SPLock wasn't found in specifications
//		res &= m_SPLock.Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_SPLock], treeManager);
		res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_TO_FUMO_REF], m_TO_FUMO_REF, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXRadioModule::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_Man], m_Man, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_Mod], m_Mod, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_FwV], m_FwV, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_HwV], m_HwV, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_SwV], m_SwV, treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_MACAddress], m_MACAddress, treeManager);
		// this line is commented because of SPLock wasn't found in specifications
		//		res &= m_SPLock.Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_SPLock], treeManager);
		res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXRadioModuleFieldName[e_TO_FUMO_REF], m_TO_FUMO_REF, treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXRadioModule::Serialize(const String& basePathName, TNDSCreator& tree) const
	{
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_Man], m_Man);
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_Mod], m_Mod);
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_FwV], m_FwV);
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_HwV], m_HwV);
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_SwV], m_SwV);
		tree.Append(basePathName, WiMAXRadioModuleFieldName[e_MACAddress], m_MACAddress);
		// this line is commented because of SPLock wasn't found in specifications
		//		res &= tree.Append(basePathName + S_slash + WiMAXRadioModuleFieldName[e_SPLock]);
		tree.Append(basePathName + S_slash + WiMAXRadioModuleFieldName[e_TO_FUMO_REF], m_TO_FUMO_REF);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAXRadioModule::Deserialize(const String& basePathName, TNDSExtractor& tree)
	{
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_Man], m_Man);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_Mod], m_Mod);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_FwV], m_FwV);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_HwV], m_HwV);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_SwV], m_SwV);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_MACAddress], m_MACAddress);
		// this line is commented because of SPLock wasn't found in specifications
		//		res &= tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_SPLock]);
		tree.GetValue(basePathName, WiMAXRadioModuleFieldName[e_TO_FUMO_REF], m_TO_FUMO_REF);
		return true;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAX::Serialize(IMOTreeManager& treeManager) const
	{
		bool res = NS_DM_Client::Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TO_WIMAX_REF], m_TO_WiMAX_REF, treeManager);

		// 	WiMAX/WiMAXRadioModule
 		for (size_t i = 0; i != m_WiMAXRadioModule.size(); ++i)
 		{
 			m_WiMAXRadioModule[i].Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule] + S_slash  
 				+ ToString(i), treeManager);
 		}
 
 		m_TerminalEquipment.Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TerminalEquipment], treeManager);
 		m_DevCap.Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_DevCap], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAX::Deserialize(IMOTreeManager& treeManager)
	{
		bool res = NS_DM_Client::Deserialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TO_WIMAX_REF], m_TO_WiMAX_REF, treeManager);

		// 	WiMAX/WiMAXRadioModule
		size_t i = 0;
		String uri(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule] + S_slash + ToString(i));
		while (treeManager.Exist(uri))
		{
			WiMAXRadioModule item;
			res &= item.Deserialize(uri, treeManager);
			m_WiMAXRadioModule.push_back(item);
			uri = WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule] + S_slash + ToString(++i);
		}

		m_TerminalEquipment.Deserialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TerminalEquipment], treeManager);
		m_DevCap.Deserialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_DevCap], treeManager);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAX::Serialize(String& xml) const
	{
		TNDSCreator tree;

		bool res = true;
		tree.Append(WiMAXFieldPath[e_TO_WIMAX_REF], WiMAXFieldName[e_TO_WIMAX_REF], m_TO_WiMAX_REF);

		// 	WiMAX/WiMAXRadioModule
		for (size_t i = 0; i != m_WiMAXRadioModule.size(); ++i)
		{
			tree.Append(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule], ToString(i));
			res &= m_WiMAXRadioModule[i].Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule] + S_slash  
				+ ToString(i), tree);
		}

		res &= m_TerminalEquipment.Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TerminalEquipment], tree);
		res &= m_DevCap.Serialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_DevCap], tree);

		tree.Get(xml);
		return res;
	}
	//-------------------------------------------------------------------------------------------

	bool WiMAX::Deserialize(const String& xml)
	{
		TNDSExtractor tree(xml);

		tree.GetValue(WiMAXFieldPath[e_TO_WIMAX_REF], WiMAXFieldName[e_TO_WIMAX_REF], m_TO_WiMAX_REF);

		// 	WiMAX/WiMAXRadioModule
		String uri(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_WiMAXRadioModule]);
		m_WiMAXRadioModule.resize(tree.GetCount(uri));
		bool res = true;
		for (size_t i = 0; i != m_WiMAXRadioModule.size(); ++i)
		{
			res &= m_WiMAXRadioModule[i].Deserialize(uri + S_slash + ToString(i), tree);
		}

		m_TerminalEquipment.Deserialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_TerminalEquipment], tree);
		m_DevCap.Deserialize(WiMAXFieldPath[e_TO_WIMAX_REF] + S_slash + WiMAXFieldName[e_DevCap], tree);
		return res;
	}
}
