/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "../../treemanager/UTestMOTree/MockDataStorage.h"
#include "ManagementObjects/DMAcc.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInDMAcc(DMAcc& dmAcc)
{
	DMAccImpl dmAccImpl;
	dmAccImpl.m_AppID = "AppID";
	dmAccImpl.m_ServerID = "ServerID";
	dmAccImpl.m_Name = "Name";
	dmAccImpl.m_PrefConRef = "PrefConRef";
	dmAccImpl.m_ToConRef.push_back("ToConRef");
	dmAccImpl.m_AAuthPref = "AAuthPref";

	dmAcc.m_DMAccImpl.push_back(dmAccImpl);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDMAccFromTree)
{
	NS_DM_Client::DMAcc originalDmAcc;
	FillInDMAcc(originalDmAcc);
	BOOST_CHECK(originalDmAcc.Serialize(*S_treeManager));

	NS_DM_Client::DMAcc newDMAcc;
	BOOST_CHECK(newDMAcc.Deserialize(*S_treeManager));
	BOOST_CHECK(newDMAcc.m_DMAccImpl[0].m_AAuthPref == "AAuthPref");
	BOOST_CHECK(newDMAcc.m_DMAccImpl[0].m_ToConRef[0] == "ToConRef");

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDMAccountInTree)
{
	NS_DM_Client::DMAcc dmAccount;
	FillInDMAcc(dmAccount);

	BOOST_CHECK(dmAccount.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DMAcc/0/AppID", fs::native);
	BOOST_CHECK(fs::exists(path));
	path = fs::path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DMAcc/0/Name", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDMAccInXml)
{
	NS_DM_Client::DMAcc dmAcc;
	FillInDMAcc(dmAcc);

	std::string dmAccXml;
	BOOST_CHECK(dmAcc.Serialize(dmAccXml));

	std::string expectedDMAcc;
	ReadFromFile("SerializeDMAccInXml.xml", expectedDMAcc);

	//std::cout << dmAccXml << std::endl << std::endl;
//	BOOST_CHECK(dmAccXml == expectedDMAcc);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDMAccFromXml)
{
	std::string dmAccXml;
	ReadFromFile("SerializeDMAccInXml.xml", dmAccXml);

	NS_DM_Client::DMAcc dmAcc;
	BOOST_CHECK(dmAcc.Deserialize(dmAccXml));
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_AAuthPref == "AAuthPref");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_ToConRef[0] == "ToConRef");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_AppID == "AppID");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_ServerID == "ServerID");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_Name == "Name");
}
//-------------------------------------------------------------------------------------------
