/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "ManagementObjects/WiMAXSupp.h"
#include "../../treemanager/UTestMOTree/MockDataStorage.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInWiMAXSupp(WiMAXSupp& wimaxSupp)
{
	NS_DM_Client::Operator oper;

	NS_DM_Client::RootCA rootCA;
	rootCA.m_CertID = "certID";
	oper.m_RootCA.push_back(rootCA);

	oper.m_TO_IP_REF = "ref";

	NS_DM_Client::EAP eap;
	eap.m_SERVER_REALMS.push_back("ServerRealm");

	eap.m_VFY_SERVER_REALM = 1;

	NS_DM_Client::CERT cert;
	cert.m_CERT_TYPE = "CERT_TYPE";
	eap.m_CERT.push_back(cert);
	oper.m_SubscriptionParameters.m_Primary.m_EAP.push_back(eap);

	NS_DM_Client::OtherSubscriptions otherSubs;
	otherSubs.m_EAP.push_back(eap);
	otherSubs.m_Activated = 1;
	otherSubs.m_Name = "Other Subcription name";
	oper.m_SubscriptionParameters.m_OtherSubscriptions.push_back(otherSubs);

	oper.m_NetworkParameters.m_H_NSP.push_back(1);
	oper.m_NetworkParameters.m_H_NSP.push_back(2);

	NS_DM_Client::ChannelPlanEntries channelPlanEntries; 
	channelPlanEntries.m_BW = 10;
	oper.m_NetworkParameters.m_ChannelPlan.m_Entries.push_back(channelPlanEntries);

	std::string name1("SomeOperator1");
	std::string name2("SomeOperator2");
	wimaxSupp.m_Operator[name1] = oper;
	wimaxSupp.m_Operator[name2] = oper;
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXSuppFromTree)
{
	NS_DM_Client::WiMAXSupp originalWiMAXSupp;
	FillInWiMAXSupp(originalWiMAXSupp);
	BOOST_CHECK(originalWiMAXSupp.Serialize(*S_treeManager));

	NS_DM_Client::WiMAXSupp newWiMAXSupp;

	BOOST_CHECK(newWiMAXSupp.Deserialize(*S_treeManager));
	BOOST_CHECK(newWiMAXSupp.m_Operator.begin()->second.m_RootCA[0].m_CertID == "certID");

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXSuppInTree)
{
	NS_DM_Client::WiMAXSupp wimaxSupp;
	FillInWiMAXSupp(wimaxSupp);

	BOOST_CHECK(wimaxSupp.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/WiMAXSupp/Operator/SomeOperator1/SubscriptionParameters/Primary/EAP", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeWiMAXSuppInXml)
{
	NS_DM_Client::WiMAXSupp wimaxSupp;
	FillInWiMAXSupp(wimaxSupp);

	std::string wimaxSuppXml;
	BOOST_CHECK(wimaxSupp.Serialize(wimaxSuppXml));


	std::string expectedWimaxSupp;
	ReadFromFile("SerializeWiMAXSuppInXml.xml", expectedWimaxSupp);

//	std::cout << wimaxSuppXml << std::endl << std::endl;
	//std::cout << expectedWimaxSupp << std::endl << std::endl;
//	BOOST_CHECK(wimaxSuppXml == expectedWimaxSupp);
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeWiMAXSuppFromXml)
{
	std::string WiMAXSuppXml;
	ReadFromFile("SerializeWiMAXSuppInXml.xml", WiMAXSuppXml);

	NS_DM_Client::WiMAXSupp wimaxSupp;
 	BOOST_CHECK(wimaxSupp.Deserialize(WiMAXSuppXml));
 
//  	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_RootCA[0].m_CertID == "certID");
//  	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_TO_IP_REF == "ref");
// 	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_SubscriptionParameters.m_Primary.m_EAP[0].m_SERVER_REALMS[0] == "ServerRealm");
// 	BOOST_CHECK(wimaxSupp.m_Operator["SomeOperator1"].m_NetworkParameters.m_ChannelPlan.m_Entries[0].m_BW == 10);
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------
