/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "NotificationListener/DMSessionRequestCommand.h"
#include "daemon/ProfileComponentsHolder.h"
#include "serverexchange/IServerExchangeManager.h"
#include "treemanager/IMOTreeManager.h"

#include "Logger/LoggerMacroses.h"

using namespace NS_DM_Client::NS_NotificationListener;
using namespace NS_DM_Client;

DMSessionRequestCommand::DMSessionRequestCommand(const SessionInfo& sessionInfo, bool checkDiggest,
	ProfileComponentsHolder& pch, NS_Logging::Logger& log)
:m_pch(pch),
m_sessionInfo(sessionInfo),
m_checkDiggest(checkDiggest),
m_logger(log)
{
}

DMSessionRequestCommand::~DMSessionRequestCommand()
{
}

bool DMSessionRequestCommand::Execute()
{
    if (!m_pch.GetServerExchangeManager() || !m_pch.GetMOTreeManager())
    {
        LERROR("DMSessionRequestCommand: ServerExchangeManager=%p, MOTreeManager=%p", m_pch.GetServerExchangeManager(), m_pch.GetMOTreeManager());
        return false;
    }

	bool result = false;
    // get DMAcc with the serverID
    AccountInfo ai;
    if (findAccount(m_sessionInfo.serverID, ai))
    {
		// check diggest (if required)
		if (!m_checkDiggest || validDiggest())
		{
			// notify ServerExchangeManager
			m_pch.GetServerExchangeManager()->RequestSessionStart(m_sessionInfo);

			result = true;
		}
    }

    return result;
}


bool DMSessionRequestCommand::findAccount(const String& serverID, AccountInfo& ai)
{
	static const char c_DMAcc[] = "./DMAcc";

	IMOTreeManager* mtm = m_pch.GetMOTreeManager();
	IMOTreeManager::ChildrenPaths accounts;

	bool found = false;
	if (e_Ok == mtm->GetChildren(c_DMAcc, accounts, NULL))
	{
		if (!accounts.empty())
		{
			for (size_t i = 0; i < accounts.size(); ++i)
			{
				IMOTreeManager::ChildrenPaths::const_reference accname = accounts[i];
				String uriAccount = c_DMAcc;
				uriAccount.append("/").append(accname.c_str());
				String curServerID;
				if (getValue(uriAccount, "ServerID", curServerID)
					&& serverID == curServerID)
				{

					found = true;
					break;
				}
			}
		}
	}

	LDEBUG("DMSessionRequestCommand::findAccount ServerID='%s' result=%d", serverID.c_str(), found);
	return found;
}


bool DMSessionRequestCommand::getValue(const String& uriNode, const char* leafname, String& result)
{
	String uri = uriNode;
	uri.append("/").append(leafname);

	return e_Ok == m_pch.GetMOTreeManager()->GetValue(uri, result, NULL);
}


bool DMSessionRequestCommand::validDiggest()
{
	bool valid = true;
	LDEBUG("hardcoded result=%d", valid);
	return true;
}

