/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include <boost/test/unit_test.hpp>
#include "common/Utils.h"


using namespace NS_DM_Client;


BOOST_AUTO_TEST_SUITE(SuiteCommonLib)


BOOST_AUTO_TEST_CASE(TestCase_CreateNonce)
{
	Funambol::NextNonce *pNonce = CreateNonce();
	
	BOOST_CHECK( pNonce != NULL );
	BOOST_CHECK( pNonce->getValueSize() > 0 );
	
	const char *pB64Nonce = pNonce->getValueAsBase64();
	BOOST_CHECK( pB64Nonce != NULL );
	BOOST_CHECK( strlen(pB64Nonce) > 0 );
	
	delete pB64Nonce;
	delete pNonce;
}

/*
BOOST_AUTO_TEST_CASE(TestCase_IsBooleanTrue)
{
	BOOST_CHECK( IsBooleanTrue(String("1"))    );
	BOOST_CHECK( IsBooleanTrue(String("true")) );
	BOOST_CHECK( IsBooleanTrue(String("TRUE")) );

	BOOST_CHECK( !IsBooleanTrue(String("sdsd"))    );
	BOOST_CHECK( !IsBooleanTrue(String("0")) );
	BOOST_CHECK( !IsBooleanTrue(String("false")) );
	BOOST_CHECK( !IsBooleanTrue(String("FALSE")) );
}
*/

BOOST_AUTO_TEST_CASE(TestCase_ToString)
{
	BOOST_CHECK( ToString( 0)    == "0"     );
	BOOST_CHECK( ToString(-1)    == "-1"    );
	BOOST_CHECK( ToString(65900) == "65900" );
}


BOOST_AUTO_TEST_SUITE_END()
