/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include <wbxml.h>
#include <wbxml_mem.h>

#include <spds/SyncMLProcessor.h>
#include "WBXMLUtils.h"

using namespace NS_DM_Client::NS_Common;

#define DEFAULT_ERROR 4444

int WBXMLUtils::Parse(const char *wbxml, const unsigned int wbxmllength, Funambol::SyncML **syncml)
{
	if (!wbxml || !wbxmllength || !syncml) return DEFAULT_ERROR;

	WBXMLError ret = WBXML_OK;
	WB_UTINY *xml = NULL;
	WB_ULONG  xml_len = 0;

	WB_UTINY *utinywbxml = (WB_UTINY *) const_cast<char *>(wbxml);

	ret = wbxml_conv_wbxml2xml_withlen(utinywbxml, wbxmllength, &xml, &xml_len, NULL);
	if (ret != WBXML_OK)
	{
		return ret;
	}

	if (xml)
	{
		Funambol::SyncMLProcessor processor;
		*syncml = processor.processMsg((char *)xml);
		wbxml_free(xml);
		return WBXML_OK;
	}
	else
	{
		return DEFAULT_ERROR; // smth not 0 and > than WBXMLError largest value
	}
}


int WBXMLUtils::Parse(const char *wbxml, const unsigned int wbxmllength, char **xml)
{
	if (!wbxml || !wbxmllength) return DEFAULT_ERROR;

	WB_ULONG  xml_len = 0;
	WB_UTINY *utinywbxml = (WB_UTINY *) const_cast<char *>(wbxml);

	return wbxml_conv_wbxml2xml_withlen(utinywbxml, wbxmllength, (WB_UTINY **) xml, &xml_len, NULL);
}


int WBXMLUtils::FormatToWBXML(const char *syncml, const char **wbxml, unsigned int *wbxmllength)
{
	WB_UTINY *utinyxml = (WB_UTINY *) const_cast<char *>(syncml);
	WB_UTINY **utinywbxml = (WB_UTINY **) const_cast<char **>(wbxml);
	return wbxml_conv_xml2wbxml_withlen(utinyxml, strlen(syncml), utinywbxml, wbxmllength, NULL);
}

