/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <base/util/utils.h>
#include "hash.h"

using namespace Funambol;

const char * NS_DM_Client::NS_Common::calculateHMAC(const char *username, const char *password, const char *b64nonce, const char *msg, int msg_len)
{
	char base64hmac[64]  = {0};
	char base64msg[64]   = {0};
	char base64up[64]    = {0};

	char digest_hmac[16] = {0};
	char digest_msg[16]  = {0};
	char digest_up[16]   = {0};

	char cnonce[64]      = {0};
	char token_up[512]   = {0};
	char result[128]     = {0};

//	H =
//	char* calculateMD5(const void* token, int len, char* wdigest)
//		  calculateMD5() writes result into preallocated non-null wdigest
//
//	B64 =
//	int b64_encode(char *dest, void *src, int len)
//		return size of encoded msg

	// username:password
	sprintf(token_up, "%s:%s", username, password);

	// H(username:password)
	calculateMD5(token_up, strlen(token_up), digest_up);

	// B64(H(username:password)
	int length_b64up = b64_encode(base64up, digest_up, 16);

	// decode b64nonce
    strcpy(cnonce, b64nonce);
    int length_nonce = b64_decode(cnonce, cnonce);

	// H(message body)
	calculateMD5(msg, msg_len, digest_msg);
	// B64(H(message body))
	int length_b64msg = b64_encode(base64msg, digest_msg, 16);

	//	sprintf(result, "%s:%s:%s", base64up, cnonce, base64msg);
	// ---> H64(H(username:password)):nonce:B64(H(message body))  <---
	memcpy(result, base64up, length_b64up);
	memcpy(&result[length_b64up], ":", 1);
	memcpy(&result[length_b64up+1], cnonce, length_nonce);
	memcpy(&result[length_b64up+1+length_nonce], ":", 1);
	memcpy(&result[length_b64up+1+length_nonce+1], base64msg, length_b64msg);

	int length_result = length_b64up+1+length_nonce+1+length_b64msg;

	// H(B64(H(username:password)):nonce:B64(H(message body)))
	calculateMD5(result, length_result, digest_hmac);

	// encode to b64 HMAC result
	b64_encode(base64hmac, digest_hmac, 16);

	return Funambol::stringdup(base64hmac);
}

const char * NS_DM_Client::NS_Common::calculateF(const char *a, const char *b, const char *S)
{
	const size_t bufsize = 512;
	if (strlen(a) + strlen(b) + strlen(S) >= bufsize) return NULL;
	
	char buffer[bufsize] = {0};
	char digestmd5[16] = {0};
	char base64digest[64] = {0};
	
	strcat(buffer, a);
	strcat(buffer, b);
	strcat(buffer, S);
	
	calculateMD5(buffer, strlen(buffer), digestmd5);
	b64_encode(base64digest, digestmd5, 16);
	
	return Funambol::stringdup(base64digest);
}
