/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "Event.h"

using namespace NS_DM_Client::NS_Common;


Event::Event(bool autoReset) : m_signaled(false), m_autoReset(autoReset)
{
	pthread_cond_init(&m_condition, NULL);
	pthread_mutex_init(&m_mutex, NULL);
}


Event::~Event()
{
	pthread_cond_destroy(&m_condition);
	pthread_mutex_destroy(&m_mutex);
}


void Event::wait()
{
	pthread_mutex_lock(&m_mutex);

	while (!m_signaled)
		pthread_cond_wait(&m_condition, &m_mutex);

	if (m_autoReset)
		m_signaled = false;

	pthread_mutex_unlock(&m_mutex);
}


void Event::reset()
{
	pthread_mutex_lock(&m_mutex);
	m_signaled = false;
	pthread_mutex_unlock(&m_mutex);
}


void Event::signal()
{
	pthread_mutex_lock(&m_mutex);

	if (!m_signaled)
	{
		m_signaled = true;
		pthread_cond_signal(&m_condition);
	}

	pthread_mutex_unlock(&m_mutex);
}



EventEM::EventEM(pthread_mutex_t &m) : m_mutex(m)
{
	pthread_cond_init(&m_condition, NULL);
}

EventEM::~EventEM()
{
	pthread_cond_destroy(&m_condition);
}

void EventEM::wait()
{
	pthread_mutex_lock(&m_mutex);
	pthread_cond_wait(&m_condition, &m_mutex);
	pthread_mutex_unlock(&m_mutex);
}

void EventEM::signal()
{
	pthread_mutex_lock(&m_mutex);
	pthread_cond_signal(&m_condition);
	pthread_mutex_unlock(&m_mutex);
}




EventEx::EventEx()
: m_param (e_NotDefined), m_signaled(false)
{
}


EventEx::~EventEx()
{
    m_param = e_NotDefined;
    m_signaled = false;
}


long EventEx::wait()
{
	pthread_mutex_lock(&m_mutex);
	if (!m_signaled)
	{
		pthread_cond_wait(&m_condition, &m_mutex);
	}
	long param = m_param;
	m_signaled = false;
	pthread_mutex_unlock(&m_mutex);

	return param;
}


void EventEx::signal(long param)
{
	pthread_mutex_lock(&m_mutex);
	m_signaled = true;
	m_param = param;
	pthread_cond_signal(&m_condition);
	pthread_mutex_unlock(&m_mutex);
}


void EventEx::signal()
{
	signal(e_NotDefined);
}
