/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "daemon/Profile.h"
#include "daemon/ProfileComponentsHolder.h"
#include "daemon/ComponentStartStopFunctors.h"

#include "executionqueue/IExecutionQueue.h"
#include "serverexchange/IServerExchangeManager.h"
#include "treemanager/IMOTreeManager.h"
#include "NotificationListener/INotificationListener.h"

#include <algorithm>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Daemon;


Profile::Profile()
:m_Enabled(false), m_compHolder(NULL)
{

}

Profile::~Profile(void)
{
    if (m_Enabled)
    {
        Enable(false);
    }

    delete m_compHolder;
    m_compHolder = NULL;
}


void    Profile::SetName(const char* name)
{
    m_Name = name;
}


const String&   Profile::GetName() const
{
    return m_Name;
}


void    Profile::SetDescription(const char* desc)
{
    m_Description = desc;
}


const String&   Profile::GetDescription() const
{
    return m_Description;
}


bool    Profile::IsEnabled() const
{
    return m_Enabled;
}


bool Profile::Enable(bool enable)
{
    if (enable == m_Enabled)
    {
        return true;
    }

    if (enable)
    {
        Components  compsStarted;
        compsStarted.reserve(m_AllComps.size());
        ComponentStarter starter(compsStarted);
        std::for_each(m_AllComps.begin(), m_AllComps.end(), starter);
        m_Enabled = starter.IsAllStarted();
        if (!m_Enabled)
        {
            ComponentStoper stopper;
            std::for_each(compsStarted.begin(), compsStarted.end(), stopper);
        }
    }
    else
    {
        ComponentStoper stopper;
        std::for_each(m_AllComps.begin(), m_AllComps.end(), stopper);
        m_Enabled = false;
    }

    return (enable == m_Enabled);
}


void    Profile::SetComponentsHolder(ProfileComponentsHolder* compHolder)
{
    if (m_compHolder)
    {
        delete compHolder;
    }
    m_compHolder = compHolder;

    m_AllComps.clear();
    const size_t max_components = 8;
    m_AllComps.reserve(max_components);

    if (m_compHolder->GetExecutionQueue())
    {
        m_AllComps.push_back(m_compHolder->GetExecutionQueue());
    }

    if (m_compHolder->GetMOTreeManager())
    {
        m_AllComps.push_back(m_compHolder->GetMOTreeManager());
    }

    if (m_compHolder->GetServerExchangeManager())
    {
        m_AllComps.push_back(m_compHolder->GetServerExchangeManager());
    }

    if (m_compHolder->GetNotificationListener())
    {
        m_AllComps.push_back(m_compHolder->GetNotificationListener());
    }


}

ProfileComponentsHolder*    Profile::GetComponentsHolder()
{
    return m_compHolder;
}
