/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "daemon/DaemonEngine.h"
#include "common/Buffer.h"
#include "base/util/StringBuffer.h"
#include "daemon/Configuration.h"
#include "daemon/Profile.h"

#include "Logger/Logger.h"
#include "Errors.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Daemon;

static const char c_LoggerInstanceName[] = "DaemonEngine";

StatusCode DaemonEngine::execute_RequestGetProfiles(const Buffer& input, StatusCode& response_res, Buffer& output)
{
    StatusCode res = response_res = e_Failed;
    size_t profiles_count = m_conf.GetProfilesCount();
    if (profiles_count != 0)
    {
        Profile* p;
        String profile_name, profile_description;
        bool profile_enabled;
        size_t pos = 0;
        size_t data_size;
        for(size_t i = 0; i < profiles_count; ++i)
        {
            p = m_conf.GetProfile(i);
            if (!p)
            {
                response_res = e_Failed;
                break;
            }
            // fetching name
            profile_name = p->GetName();
            data_size = profile_name.length();
            output.Allocate(output.Size() + sizeof(size_t) + data_size);
            memcpy((char*)output.GetPointer() + pos, &data_size, sizeof(size_t));
            pos += sizeof(size_t);
            memcpy((char*)output.GetPointer() + pos, profile_name.c_str(), data_size);
            pos += data_size;
            // fetching description
            profile_description = p->GetDescription();
            data_size = profile_description.length();
            output.Allocate(output.Size() + sizeof(size_t) + data_size);
            memcpy((char*)output.GetPointer() + pos, &data_size, sizeof(size_t));
            pos += sizeof(size_t);
            memcpy((char*)output.GetPointer() + pos, profile_description.c_str(), data_size);
            pos += data_size;
            // fetching is enabled
            profile_enabled = p->IsEnabled();
            output.Allocate(output.Size() + sizeof(bool));
            memcpy((char*)output.GetPointer() + pos, &profile_enabled, sizeof(bool));
            pos += sizeof(bool);
            if (i == profiles_count - 1)
            {
                response_res = res = e_Ok;
            }
        }
    }
	return res;
}

StatusCode DaemonEngine::execute_RequestSetProfileState(const Buffer& input, StatusCode& response_res, Buffer& output)
{
    StatusCode res = response_res = e_Failed;

    size_t name_length;
    String profile_name;
    bool profile_enabled;

    name_length = *((size_t*)input.GetPointer());
    char* name = (char*)malloc(name_length + 1);
    memcpy(name, (char*)input.GetPointer() + sizeof(name_length), name_length);
    name[name_length] = '\0';
    profile_name = name;
    free(name);
    profile_enabled = *((bool*)((char*)input.GetPointer() + sizeof(name_length) + name_length));

    size_t profiles_count = m_conf.GetProfilesCount();
    if (profiles_count != 0)
    {
        Profile* p;
        for(size_t i = 0; i < profiles_count; ++i)
        {
            p = m_conf.GetProfile(i);
            if (!p)
            {
                response_res = e_Failed;
                break;
            }
            if (p->GetName() == profile_name)
            {
                if (p->Enable(profile_enabled))
                {
                    res = response_res = e_Ok;
                    break;
                }
            }
            if (i == profiles_count - 1)
            {
                res = response_res = e_NotFound;
            }
        }
    }
    else if (profiles_count == 0)
    {
        res = response_res = e_NotFound;
    }
	return res;
}

