/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#define BOOST_TEST_MAIN

#include <iostream>
#include <boost/test/included/unit_test.hpp>
#include "Common.h"
#include "DataStorage/IDataStorage.h"
#include "common/Buffer.h"
#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"

#include "MockDataStorage.h"
#include "MockDeviceAdapter.h"
#include "MockDeviceUpdater.h"

NS_DM_Client::ProfileComponentsHolder* S_ProfileHolder = 0;
NS_DM_Client::IDeviceAdapter* S_DeviceAdapter = 0;
NS_DM_Client::IDeviceUpdater* S_DeviceUpdater = 0;
NS_DM_Client::NS_DataStorage::IDataStorage* S_dataStorage = 0;
NS_DM_Client::MOTreeManager* S_treeManager = 0;

//const char* c_testProfile = "MOTreeTest_Profile";
const char* c_testProfile = "";
const char* const c_testPrivateDataPath = "/tmp/Funambol/DMClient/DataStorage";
const char* c_PrivateDataExt = ".priv";

class InitTreeManager
{
public:
	InitTreeManager()
	{
		//_CrtSetBreakAlloc(422);

		S_dataStorage = NS_DM_Client::NS_DataStorage::CreateDataStorage(c_testProfile, c_testPrivateDataPath);
		S_treeManager = new NS_DM_Client::MOTreeManager;
		S_DeviceAdapter = new NS_DM_Client::MockDeviceAdapter();
		S_DeviceUpdater = new NS_DM_Client::MockDeviceUpdater(); // will be deletes in MOTree::Transaction
        S_ProfileHolder = new NS_DM_Client::ProfileComponentsHolder();
        S_ProfileHolder->SetDataStorage(S_dataStorage);
		S_ProfileHolder->SetDeviceAdapter(S_DeviceAdapter);
		S_ProfileHolder->SetMOTreeManager(S_treeManager);

        NS_DM_Client::StringMap settings;
        S_treeManager->Init(settings, "MOTreeManagerUnitTests", *S_ProfileHolder);
		NS_DM_Client::SetDeviceUpdater(*S_treeManager, S_DeviceUpdater);

		std::cout << "Setup" << std::endl;
	}

	~InitTreeManager()
	{
		delete S_ProfileHolder;
		std::cout << "Teardown" << std::endl;
        fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() + (NS_DM_Client::String)"/" + c_testProfile);
	}
};

BOOST_GLOBAL_FIXTURE(InitTreeManager);
