/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <syncml/core/Alert.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"

#include "treemanager/IMOTreeManager.h"
#include "treemanager/AlertResponseCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/wrappers/SCommandFactory.h"

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log
#define LOG_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;

const char* const c_LogName = "AlertResponseCommand";

AlertResponseCommand::AlertResponseCommand
    (ProfileComponentsHolder* prholder, AlertPtr& cmd, StatusCode getCommandStatus, const String& msgID, std::vector<String> &results, const char *serverid)
    : MOTreeResponseCommand(prholder, cmd, getCommandStatus, msgID, serverid), m_AlertCommand(cmd), m_results(results)
{
}


AlertResponseCommand::~AlertResponseCommand()
{
}


bool AlertResponseCommand::Execute()
{
    GDLINFO("FUNCTION STARTED");

    bool res = m_pProfile && m_AlertCommand.get();
    if (res)
    {
		res = performOperation();
    }
    else
    {
        GDLERROR("component holder or command instanse not valid");
    }
    GDLINFO("FUNCTION END. Res: %d", res);
    return res;
}


bool AlertResponseCommand::performOperation()
{
    bool res = false;
    SStatusCommandPtr ptrStatus =
        NS_SyncMLCommand::SCommandFactory::CreateStatus(m_status, *m_AlertCommand.get());

    if (ptrStatus.get())
    {
        if (m_status == e_Ok && !m_results.empty())
        {
        	ptrStatus->Prepare();
        	Funambol::ItemizedCommand *pCommand = ptrStatus->Internal().get();
        	if (pCommand)
        	{
        		Funambol::ArrayList resultItems;
        		for (unsigned int i=0; i<m_results.size(); ++i)
        		{
        			Funambol::ComplexData data(m_results[i].c_str());
        			Funambol::Item item;
        			item.setData(&data);
        			resultItems.add(item);
        		}
        		pCommand->setItems(&resultItems);
        	}
        }

        enqueueCommand(ptrStatus);
        res = true;
    }
    else
    {
        GDLERROR("SCommandFactory::CreateStatusMessage failed");
    }

    return res;
}

