/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <syncml/core/Delete.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "Errors.h"
#include "executionqueue/IExecutionQueue.h"
#include "Logger/Logger.h"
#include "treemanager/MOTreeDeleteCommand.h"
#include "treemanager/IMOTreeManager.h"

const char* const c_DeleteCommandLog = "MOTreeDeleteCommand";

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;


MOTreeDeleteCommand::MOTreeDeleteCommand(ProfileComponentsHolder* prholder,
										 DeletePtr& cmd,
										 const String& msgID,
                                        const char* serverId)
    : ActionCommand(prholder, cmd, msgID, serverId), m_DeleteCommand(cmd)
{
}


MOTreeDeleteCommand::~MOTreeDeleteCommand(void)
{
}


bool MOTreeDeleteCommand::Execute()
{
    LOG_INFO_(NS_Logging::GetLogger(c_DeleteCommandLog), "%s", "FUNCTION STARTED");

    bool res = m_pProfile && m_DeleteCommand.get();
    if (res)
    {
		res = false;
		m_resCode = performOperation();
		res = InvokeResult();
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_DeleteCommandLog),
            "%s", "component holder or command instanse not valid");
    }

    LOG_INFO_(NS_Logging::GetLogger(c_DeleteCommandLog), "%s%d", "FUNCTION END. Res: ", res);
    return res;
}


StatusCode MOTreeDeleteCommand::performOperation()
{
    StatusCode res = e_Ok;
    Funambol::ArrayList* items = m_DeleteCommand.get()->getItems();
    if (items)
    {
        Funambol::Item* item = 0;
        int count = items->size();
        for (int i = 0; i < count; ++i)
        {
            if ((item = dynamic_cast<Funambol::Item*> ((*items)[i])) != 0)
            {
                const URI uri = item->getTarget()->getLocURI();
                if ( (res = m_pProfile->GetMOTreeManager()->Delete(uri, m_serverID)) != e_Ok)
                {
                    LOG_ERROR_(NS_Logging::GetLogger(c_DeleteCommandLog),
                        "%s", "delete item from MO Tree Manager failed");
                    break;
                }
            }
            else
            {
                LOG_ERROR_(NS_Logging::GetLogger(c_DeleteCommandLog),
                    "%s", "casting to Funambol::Item failed");
                break;
            }
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_DeleteCommandLog),
            "%s", "get items from ItemizedCommand failed");
    }
    return res;
}

