/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "serverexchange/firmware/FirmwareManager.h"
#include "ServerExchangeManagerMock.h"

namespace NS_DM_Client
{

using namespace NS_Communication;
bool ServerExchangeManagerMock::Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch)
{

    return true;
}

bool ServerExchangeManagerMock::Start()
{

    return true;
}

bool ServerExchangeManagerMock::Stop()
{

    return true;
}

void ServerExchangeManagerMock::Release()
{

}


void ServerExchangeManagerMock::AddCommand(NS_SyncMLCommand::SCommandPtr ptrCommand, const char *connid)
{

}
void ServerExchangeManagerMock::AddCommands(NS_SyncMLCommand::SCommandsArray &commands, const char *connid)
{

}
NS_Communication::Connection * ServerExchangeManagerMock::DefaultConnection()
{
	return NULL;
}
void ServerExchangeManagerMock::HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB)
{

}
void ServerExchangeManagerMock::NotifyDiagnosticsReady(String &serverID, String &origID)
{

}
bool ServerExchangeManagerMock::HasAccountFor(String &serverID)
{
	return false;
}
void ServerExchangeManagerMock::SetServerPollerInfo(bool pollingSupported, int pollingInterval, int pollingAttempts)
{

}
void ServerExchangeManagerMock::SetConnectionsInfo(NS_Communication::ConnInfoList &)
{

}
void ServerExchangeManagerMock::SetDevInfo(Funambol::DevInf &devInf)
{

}
void ServerExchangeManagerMock::StartClientSession()
{

}
void ServerExchangeManagerMock::RequestFWUpdate(bool userInitiated, const char *fumouri, int data)
{

}
void ServerExchangeManagerMock::RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo)
{

}

void ServerExchangeManagerMock::ProcessBootstrapMessage(const char *bsm, uint length)
{
}

void ServerExchangeManagerMock::UpdateFW(ExecPtr cmd)
{

}

void ServerExchangeManagerMock::StartWIB(HomeNSPID nspID, const char* operatorName)
{
}

NS_Communication::FirmwareManager* ServerExchangeManagerMock::GetFirmwareManager()
{
	return NULL;
}

}
