/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "treemanager/FUMORefUpdateListener.h"
#include "../Node.h"

static const char* listen_uri = "./WiMAX/WiMAXRadioModule/X/TO-FUMO-REF";
static const char* diff_key = "X";
static const size_t diff_ins_pos = 25;

namespace NS_DM_Client
{

FUMORefUpdateListener::FUMORefUpdateListener(ProfileComponentsHolder& pch) : m_component_holder(pch)
{

}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::Init(ProfileComponentsHolder& pch)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::Release()
{
    delete this;
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnAdd(const URI& uri)
{
    if (isListenURI(uri))
    {
        if (!m_component_holder.GetDataStorage())
        {
            return false;
        }

        Node node(uri, m_component_holder.GetDataStorage());
        if (node.Exist() && node.IsLeaf())
        {
            String value;
            if (node.GetContent(value))
            {
                if (value.empty())
                {
                    node.SetContent(m_defValue);
                }
            }
        }
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnDelete(const URI& uri)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnReplace(const URI& uri)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnCopy(const URI& source, const URI& dest)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::isListenURI(const URI& uri) const
{
    if (uri.length() >= strlen(listen_uri))
    {
        URI merged_uri = uri.substr(0, diff_ins_pos) + (URI)diff_key + uri.substr(diff_ins_pos + 1);
        return (merged_uri.compare(listen_uri) == 0) ? true : false;
    }
    return false;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::SetDefaultValue(const String& defValue)
{
    m_defValue = defValue;
    return true;
}

}
