/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "UserInteractionDefs.h"

namespace NS_DM_Client
{

class IMessageHandler
{
public:
    virtual bool Init() = 0;
    virtual bool Release() = 0;

    //------------------------------------------------------------------------------------------------------
    // e_Ok - display message
    virtual StatusCode Display(const char* message, long min_time, long max_time) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user choise "Yes"
    // e_OperationCancelled:
    //  - user cancel
    //  - user choise "No"
    //  - max_time is spent
    virtual StatusCode Confirmation(const char* message, long min_time, long max_time) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user type input
    // e_OperationCancelled:
    //  - user cancel
    //  - max_time is spent
    virtual StatusCode UserInput(const char* message, long min_time, long max_time, char*& input,
        // max_len - maximum user input lenght
        // echo_password - input echo type set as password input or not
        long max_len = 0, bool echo_password = 0) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user set chiose
    // e_OperationCancelled:
    //  - user cancel
    //  - max_time is spent
    virtual StatusCode UserChoice(const char* message, long min_time, long max_time,
        // avialable_choise_set - avialable choise set separated by "-"
        // choise_set - user choise set separated by "-"
        const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - progress is displayed
    // e_OperationCancelled:
    //  - user cancel

    // size_to_download:
    //  > 0 - size in bytes download needed
    //  = 0 - download is finished
    //  < 0 - download is terminated from the side of server
    virtual StatusCode ProgressNotification(const char* message, long min_time, long max_time,
        // size in bytes download needed
        long size_to_download) = 0;
    //------------------------------------------------------------------------------------------------------

    virtual void ReleaseString(char* str) = 0;

    virtual ~IMessageHandler() { }
};

}
