/* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "platform.h"

#ifdef PLATFORM_LINUX
	#define CLIENT_ADAPTER_API
#elif defined(PLATFORM_WINDOWS)
	#ifdef CLIENT_ADAPTER_EXPORTS
		#define CLIENT_ADAPTER_API __declspec(dllexport)
	#else
		#define CLIENT_ADAPTER_API __declspec(dllimport)
	#endif // CLIENT_ADAPTER_EXPORTS
#else
	#define CLIENT_ADAPTER_API
#endif


namespace NS_DM_Client
{
	struct DevInfo;
	struct DevDetail;
	struct DMAcc;
	struct WiMAX;
	struct WiMAXSupp;

      class IClientAdapter
      {
      public:
            virtual ~IClientDevice() = 0;
            virtual bool Open() = 0;
            virtual bool Start() = 0;
            virtual bool Close() = 0;

            virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
            virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
            virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
            virtual bool GetWiMAX(WiMAX& wimax) = 0;
            virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

            virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
            virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
            virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
            virtual bool SetWiMAX(const WiMAX& wimax) = 0;
            virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;

            virtual bool UpdateFUMO() = 0;
            virtual bool CheckFUMO() = 0;      // check if FUMO updates exist on server
            virtual bool DownloadFUMO() = 0;   // request download FUMO updates from server
            virtual bool GetOperatorProfile() = 0;
      };

}

extern "C" CLIENT_ADAPTER_API void* CreateClientAdapter(long param);
