/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <NotificationListener/IDataSink.h>
#include <IRunner.h>
#include <commontypes.h>
#include <Event.h>
#include <CritSection.h>
#include <Logger/Logger.h>

namespace NS_DM_Client
{
    class ProfileComponentsHolder;

    namespace NS_NotificationListener
    {
        class SessionInfo;

        class MessageHandler : public IDataSink, public NS_Common::IRunner
        {
        public:
            typedef buffer_t    message_t;

            enum Signals
            {
                e_NewMsg = NS_Common::EventEx::e_UserSignal,

                e_Stop = NS_Common::EventEx::e_Stop
            };

            MessageHandler(ProfileComponentsHolder& pch, bool checkNotificationDiggest, 
				bool plainBootstrap, bool cipherHeaderPresent, NS_Logging::Logger& logger);
            virtual ~MessageHandler();

            virtual void    Write(const void* buf, size_t size);

            virtual void    Start();
            virtual void    Stop();

        protected:
            void    add(message_t& msg);
            bool    get(message_t& msg);

            bool    checkNotificationMessage(const char* buf, size_t size, SessionInfo& sessInfo) const;
            bool    checkBootstrapMessage(const char* buf, size_t size, buffer_t& bsdata) const;

        private:
            MessageHandler(MessageHandler&);
            MessageHandler& operator = (MessageHandler&);

            std::vector<message_t>  m_messages;
            NS_Common::CritSection  m_csMsgHandler;
            NS_Common::EventEx         m_newMsg;

            ProfileComponentsHolder& m_pch;

            NS_Logging::Logger&     m_logger;

			bool m_checkNotificationDiggest;
			bool m_plainBootstrap;
			bool m_cipherHeaderPresent;

        };
    }
}
