/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <pthread.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Class represents a sync object on which thread may wait
		class Event
		{
		public:
			Event(bool autoReset = true);
			~Event();

			void wait();
			void reset();
			void signal();

		protected:
			pthread_cond_t  m_condition;
			pthread_mutex_t m_mutex;
		private:
			bool m_signaled;
			bool m_autoReset;
		};

		/// Event with [E]xternal [M]utex
		class EventEM
		{
		public:
            /// Create event with extenal mutex
            ///
            /// Mutex should be initialized before calling the wait or signal
            /// Mutex is not destroyed by the event object.
			EventEM(pthread_mutex_t &m);
			~EventEM();

			void wait();
			void signal();

		protected:
			pthread_cond_t m_condition;
			pthread_mutex_t &m_mutex;
		};

        class EventEx : private Event
        {
        public:
                enum
                {
                    e_NotDefined = 0,
                    e_Stop = 1,

                    e_UserSignal
                };

                EventEx();
                ~EventEx();

                long    wait();
                void    signal(long param);
                void    signal();

        private:
                volatile long   m_param;
                volatile bool   m_signaled;

        };


	}
}
