/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <daemon/IDaemonEngine.h>
#include <daemon/Configuration.h>

namespace NS_Logging
{
    class Logger;
}

namespace NS_DM_Client
{
	namespace NS_DataStorage
    {
        class IConfigurationStorage;
    }

    class ClientAdapterStub;
	
	class DaemonEngine : public IDaemonEngine
	{
	public:
		DaemonEngine();
		virtual ~DaemonEngine();

		virtual bool Start();
		virtual bool Stop();
		
		virtual void Release();

		virtual StatusCode HandleClientRequest(const UIMessageType& type, const Buffer& input, StatusCode& res, Buffer& output);

	private:
		bool loadConfiguration();
		bool initComponents();
		bool startManagers();

        bool isRunning() const;

        NS_DataStorage::IConfigurationStorage*   getConfigurationStorage();

        // testing API
        StatusCode execute_RequestGetValueFromTreeCommand(const Buffer& input, StatusCode& res, Buffer& output);
        StatusCode execute_RequestFirmwareUpdate(bool userInitiated, const Buffer& input);
        // user interface API
        StatusCode execute_RequestGetProfiles(const Buffer& input, StatusCode& res, Buffer& output);
	    StatusCode execute_RequestSetProfileState(const Buffer& input, StatusCode& res, Buffer& output);
		
		// ClientAdapter
		void readConfigurationForClientAdapter(NS_Daemon::StringBuffer& configData, StringMap& settings, String& loggerInstance);
	
	private:
		DaemonEngine(DaemonEngine&);
		DaemonEngine& operator = (DaemonEngine&);

    private:
        bool    m_Started;
        NS_Logging::Logger&  m_logger;

        NS_DataStorage::IConfigurationStorage* m_ConfStorage;

        NS_Daemon::Configuration m_conf;

        ClientAdapterStub*	m_clientAdapterStub;

    };

}
